package server

import (
	"encoding/json"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

func (s *Server) unistatHandler(c echo.Context) error {
	signals := s.statCounter.FlushSignals()
	body, err := json.Marshal(signals)
	if err != nil {
		simplelog.Error("failed to marshal unistat signals", "err", err)
		body = []byte{}
	}

	return c.Blob(http.StatusOK, echo.MIMEApplicationJSONCharsetUTF8, body)
}

func (s *Server) pushSolomonHandler(c echo.Context) error {
	return c.JSON(http.StatusOK, nil)
	//body, err := ioutil.ReadAll(c.Request().Body)
	//if err != nil {
	//	simplelog.Error("failed to parse stat body", "err", err)
	//	return err
	//}
	//
	//if !json.Valid(body) {
	//	simplelog.Error("failed to validate stat body")
	//	return errors.New("failed to validate stat body")
	//}
	//
	//s.statSender.PushMsg(body)
	//return c.JSON(http.StatusOK, nil)
}
