package srvbb

import (
	"fmt"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
)

var (
	TVM        *tvmtool.Client
	Intranet   blackbox.Client
	Production blackbox.Client
)

func init() {
	var err error
	TVM, err = tvmtool.NewDeployClient()
	if err != nil {
		panic(fmt.Sprintf("failed to create TVM client: %s", err))
	}

	Intranet, err = httpbb.NewIntranet(httpbb.WithTVM(TVM))
	if err != nil {
		panic(fmt.Sprintf("failed to create intranet bb client: %s", err))
	}

	Production, err = httpbb.NewProd(httpbb.WithTVM(TVM))
	if err != nil {
		panic(fmt.Sprintf("failed to create intranet bb client: %s", err))
	}
}
