package st

import (
	"crypto/sha256"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"

	"a.yandex-team.ru/security/ant-secret/web/internal/httpclient"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

const (
	upstreamURL = "https://st-api.yandex-team.ru/v2/issues?"
)

type (
	stResponse []struct {
		Key string `json:"key"`
	}
)

func GetSecAlerts(sha1 string, sessionID string) (alerts []string) {
	query := url.Values{
		"query": {
			`Queue:SECALERTS "Alert ID":` + calcSha256(sha1) +
				` OR "Alert ID":` + calcSha256(sha1+",user_secrets_search"),
		},
	}

	req, err := http.NewRequest("GET", upstreamURL+query.Encode(), nil)
	if err != nil {
		simplelog.Error("failed to create ST request", "err", err)
		return
	}
	req.AddCookie(&http.Cookie{
		Name:  "Session_id",
		Value: sessionID,
	})

	res, err := httpclient.Client.Do(req)
	if err != nil {
		simplelog.Error("failed to call ST", "sha1", sha1, "err", err)
		return
	}

	defer func() {
		_, _ = io.CopyN(ioutil.Discard, res.Body, 128<<10)
		_ = res.Body.Close()
	}()

	if res.StatusCode != 200 {
		simplelog.Error("failed to call ST - unexpected status",
			"sha1", sha1, "status", res.StatusCode)
		return
	}

	var stResp stResponse
	err = json.NewDecoder(res.Body).Decode(&stResp)
	if err != nil {
		simplelog.Error("failed to parse ST response", "sha1", sha1, "err", err)
		return
	}

	alerts = make([]string, len(stResp))
	for i, item := range stResp {
		alerts[i] = item.Key
	}
	return
}

func calcSha256(secret string) string {
	return fmt.Sprintf("%x", sha256.Sum256([]byte(secret)))
}
