package staff

import (
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strconv"
)

type (
	personInfo struct {
		Result []struct {
			UID string
		}
	}
)

func DepartmentUsers(authToken, department string) (uids []uint64, err error) {
	params := url.Values{
		"official.is_dismissed": {"false"},
		"department_group.url":  {department},
		"_fields":               {"uid"},
	}
	req, err := http.NewRequest("GET", "https://staff-api.yandex-team.ru/v3/persons?"+params.Encode(), nil)
	if err != nil {
		return
	}

	req.Header.Set("Authorization", fmt.Sprintf("OAuth %s", authToken))
	resp, err := http.DefaultClient.Do(req)
	if err != nil {
		return
	}

	defer func() {
		_, _ = io.CopyN(ioutil.Discard, resp.Body, 128<<10)
		_ = resp.Body.Close()
	}()

	if resp.StatusCode != 200 {
		err = fmt.Errorf("failed to get staff persons: %d", resp.StatusCode)
		return
	}

	var info personInfo
	err = json.NewDecoder(resp.Body).Decode(&info)
	if err != nil {
		return
	}

	for _, user := range info.Result {
		uid, err := strconv.ParseUint(user.UID, 10, 64)
		if err == nil && uid > 0 {
			uids = append(uids, uid)
		}
	}
	return
}
