package unistat

import (
	"sync/atomic"
)

/*
* documentation for stats semantic: https://wiki.yandex-team.ru/golovan/stat-handle/#defoltnyesigopt-suffiksy
 */
type Counter struct {
	unknownCacheHit uint64
	hotHit          uint64
	unknownFetch    uint64
	knownFetch      uint64
	failedFetch     uint64
}

func NewCounter() *Counter {
	return &Counter{}
}

func (c *Counter) AddUnknownCacheHit() {
	atomic.AddUint64(&c.unknownCacheHit, 1)
}

func (c *Counter) AddHotHit() {
	atomic.AddUint64(&c.hotHit, 1)
}

func (c *Counter) AddUnknownFetch() {
	atomic.AddUint64(&c.unknownFetch, 1)
}

func (c *Counter) AddKnownFetch() {
	atomic.AddUint64(&c.knownFetch, 1)
}

func (c *Counter) AddFailedFetch() {
	atomic.AddUint64(&c.failedFetch, 1)
}

func (c *Counter) FlushSignals() [][]interface{} {
	return [][]interface{}{
		{"unknown-cache-hit_summ", atomic.SwapUint64(&c.unknownCacheHit, 0)},
		{"hot-hit_summ", atomic.SwapUint64(&c.hotHit, 0)},
		{"unknown-fetch_summ", atomic.SwapUint64(&c.unknownFetch, 0)},
		{"known-fetch_summ", atomic.SwapUint64(&c.knownFetch, 0)},
		{"failed-fetch_summ", atomic.SwapUint64(&c.failedFetch, 0)},
	}
}
