package validator

import (
	"fmt"

	"a.yandex-team.ru/security/ant-secret/web/internal/cache"
)

type (
	Context struct {
		DB     *cache.DB
		Secret string
		Sha1   string
		UserIP string
	}

	ValidateTokenFn func(ctx Context) (info *Info, valid bool, ok bool)

	MatchTokenFn func(ctx Context) (matched bool)

	Validator struct {
		Name      string
		RouteName string
		Validate  ValidateTokenFn
		Match     MatchTokenFn
		Cacheable bool
	}

	Info struct {
		Type           string
		User           string
		Owners         []string
		AdditionalInfo map[string]interface{}
		InternalInfo   map[string]interface{}
	}
)

func StaffOwners(logins ...string) []string {
	out := make([]string, len(logins))
	for i, login := range logins {
		out[i] = StaffOwner(login)
	}

	return out
}

func StaffOwner(login string) string {
	return fmt.Sprintf("staff:%s", login)
}

func ABCOwners(services ...string) []string {
	out := make([]string, len(services))
	for i, service := range services {
		out[i] = ABCOwner(service)
	}

	return out
}

func ABCOwner(service string) string {
	return fmt.Sprintf("abc:%s", service)
}
