package validators

import (
	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/disabled"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/github"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/jwt"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/slack"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/staffkeys"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/staffrawkeys"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/telegram"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/tvm"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/yandexoauth"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/yandexsession"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/ycapikey"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/yccookie"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/yctoken"
)

// TokenValidators order matters!
var TokenValidators = []validator.Validator{
	{
		Name:      "Yandex OAuth",
		RouteName: "yandex-oauth",
		Validate:  yandexoauth.Validate,
		Match:     yandexoauth.Match,
		Cacheable: true,
	},
	{
		Name:      "Yandex Session",
		RouteName: "yandex-session",
		Validate:  yandexsession.Validate,
		Match:     yandexsession.Match,
		Cacheable: true,
	},
	{
		Name:      "TVM",
		RouteName: "tvm",
		Validate:  tvm.Validate,
		Match:     tvm.Match,
		Cacheable: false,
	},
	{
		Name:      "YC ApiKey",
		RouteName: "yc-apikey",
		Validate:  ycapikey.Validate,
		Match:     ycapikey.Match,
		Cacheable: true,
	},
	{
		Name:      "YC Cookie",
		RouteName: "yc-cookie",
		Validate:  yccookie.Validate,
		Match:     yccookie.Match,
		Cacheable: true,
	},
	{
		Name:      "YC Token",
		RouteName: "yc-token",
		Validate:  yctoken.Validate,
		Match:     yctoken.Match,
		Cacheable: true,
	},
	//{
	//	Name:      "S3 MDS",
	//	RouteName: "s3-mds",
	//	Validate:  s3_mds.Validate,
	//	Match:     s3_mds.Match,
	//},
	{
		Name:      "JWT",
		RouteName: "jwt",
		Validate:  jwt.Validate,
		Match:     jwt.Match,
		Cacheable: true,
	},
	// Temporary disabled: https://st.yandex-team.ru/ANTSECRET-61
	//{
	//	Name:      "Xiva",
	//	RouteName: "xiva",
	//	Validate:  xiva.Validate,
	//	Match:     xiva.Match,
	//	Cacheable: true,
	//},
	{
		Name:      "Xiva",
		RouteName: "xiva",
		Validate:  disabled.Validate,
		Match:     disabled.Match,
		Cacheable: false,
	},
	{
		Name:      "Telegram",
		RouteName: "telegram",
		Validate:  telegram.Validate,
		Match:     telegram.Match,
		Cacheable: true,
	},
	{
		Name:      "Slack",
		RouteName: "slack",
		Validate:  slack.Validate,
		Match:     slack.Match,
		Cacheable: true,
	},
	{
		Name:      "Github Auth",
		RouteName: "github",
		Validate:  github.Validate,
		Match:     github.Match,
		Cacheable: true,
	},
}

var KeyValidators = []validator.Validator{
	{
		Name:      "Yandex Staff SSH key",
		RouteName: "staff-ssh",
		Validate:  staffkeys.Validate,
		Match:     staffkeys.Match,
		Cacheable: false,
	},
	{
		Name:      "Yandex Staff SSH key",
		RouteName: "staff-raw-ssh",
		Validate:  staffrawkeys.Validate,
		Match:     staffrawkeys.Match,
		Cacheable: false,
	},
}

var Validators = append(TokenValidators, KeyValidators...)
