package jwt

import (
	"encoding/base64"
	"strings"

	"a.yandex-team.ru/security/ant-secret/web/internal/stringutils"
	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

func Match(ctx validator.Context) (matched bool) {
	token := ctx.Secret
	if len(token) < 60 {
		// too short
		return false
	}
	parts := strings.Split(token, ".")
	if i := len(parts); i != 2 && i != 3 {
		// not JWT
		return false
	}
	for _, p := range parts {
		if !stringutils.IsBase64Url(p) {
			// must be base64 encoded
			return false
		}
	}
	return true
}

func Validate(ctx validator.Context) (info *validator.Info, valid bool, ok bool) {
	if !Match(ctx) {
		return
	}

	parts := strings.Split(ctx.Secret, ".")
	header, err := base64.RawURLEncoding.DecodeString(parts[0])
	if err != nil {
		simplelog.Warn("failed to decode JWT header", "err", err)
		return
	}

	payload, err := base64.RawURLEncoding.DecodeString(parts[1])
	if err != nil {
		simplelog.Warn("failed to decode JWT payload", "err", err)
		return
	}

	ok = true
	valid = true
	info = &validator.Info{
		Type: "JWT",
		AdditionalInfo: map[string]interface{}{
			"header":  string(header),
			"payload": string(payload),
		},
	}
	return
}
