package ssl

import (
	"a.yandex-team.ru/security/ant-secret/web/internal/cache"
)

var (
	// CA names must be synced with https://a.yandex-team.ru/arc/trunk/arcadia/security/ant-secret/cacher/crls/updater.py
	clientCAs = map[string]string{
		"YandexInternalRootCA": "yandex_internal_root_ca",
		"YandexInternalCA":     "yandex_internal_ca",
		"YandexRCCA":           "yandex_rcca",
		"YandexCLCA":           "yandex_clca",
	}

	// CA names must be synced with https://a.yandex-team.ru/arc/trunk/arcadia/security/ant-secret/cacher/crls/updater.py
	serverCAs = map[string]string{
		"Yandex CA": "yandex_ca",
		"GlobalSign Organization Validation CA - SHA256 - G1": "yandex_ca",
		"GlobalSign Organization Validation CA - SHA256 - G2": "yandex_ca",
		"GlobalSign Extended Validation CA - SHA256 - G3":     "yandex_ca",
		"Certum Trusted Network CA":                           "yandex_ca",
	}
)

type (
	ValidationRequest struct {
		IsClient bool     `json:"client"`
		IsServer bool     `json:"server"`
		Serial   string   `json:"serial"`
		Chain    []string `json:"chain"`
	}
)

func Validate(db *cache.DB, request ValidationRequest) (valid bool, revoked bool) {
	if !request.IsClient && !request.IsServer {
		return
	}

	for _, cn := range request.Chain {
		if request.IsClient {
			if caName, ok := clientCAs[cn]; ok {
				valid = true
				if request.Serial != "" && caName != "" {
					revoked, _ = db.IsTLSRevoked(caName, request.Serial)
				}
				return
			}
		}

		if request.IsServer {
			if caName, ok := serverCAs[cn]; ok {
				valid = true
				if request.Serial != "" && caName != "" {
					revoked, _ = db.IsTLSRevoked(caName, request.Serial)
					// Revoked server auth certs -> not valid certs
					valid = !revoked
					return
				}
				return
			}
		}
	}

	return
}
