package staffkeys

import (
	"regexp"
	"strings"

	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
)

var (
	fingerprintRe = regexp.MustCompile(`^(?:[a-f0-9]{2}:){15}[a-f0-9]{2}$`)
)

func Match(ctx validator.Context) (matched bool) {
	return fingerprintRe.MatchString(ctx.Secret)
}

func Validate(ctx validator.Context) (info *validator.Info, valid bool, ok bool) {
	logins, err := ctx.DB.SSHKeyLogins(ctx.Secret)
	if err != nil {
		return
	}

	ok = true
	valid = len(logins) > 0
	if valid {
		info = &validator.Info{
			Type:   "StaffSSH",
			User:   strings.Join(logins, ","),
			Owners: validator.StaffOwners(logins...),
		}
	}
	return
}
