package staffrawkeys

import (
	"strings"

	"golang.org/x/crypto/ssh"

	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
	"a.yandex-team.ru/security/ant-secret/web/internal/validators/staffkeys"
)

const (
	signature = "PRIVATE KEY-----"
)

func Match(ctx validator.Context) (matched bool) {
	return strings.Contains(ctx.Secret, signature)
}

func Validate(ctx validator.Context) (info *validator.Info, valid bool, ok bool) {
	if !Match(ctx) {
		return
	}

	keyContent := []byte(ctx.Secret)
	signer, err := ssh.ParsePrivateKey(keyContent)
	if err != nil {
		return
	}

	pubKey := signer.PublicKey()
	fingerPrint := ssh.FingerprintLegacyMD5(pubKey)
	ctx.Secret = fingerPrint
	info, valid, ok = staffkeys.Validate(ctx)
	return
}
