package yccookie

import (
	"context"
	"regexp"

	cloudauth "a.yandex-team.ru/cloud/iam/accessservice/client/iam-access-service-client-go/v1"
	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
	"a.yandex-team.ru/security/ant-secret/web/internal/ycauth"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

var cookieRe = regexp.MustCompile(`^c1\.[A-Z0-9a-z_-]+[=]{0,2}\.[A-Z0-9a-z_-]{86}[=]{0,2}$`)

func Match(ctx validator.Context) bool {
	return cookieRe.MatchString(ctx.Secret)
}

func Validate(ctx validator.Context) (*validator.Info, bool, bool) {
	subject, err := ycauth.Authenticate(context.Background(), cloudauth.NewIAMCookie(ctx.Secret))
	if err != nil {
		simplelog.Error("unable to check yc cookie", "err", err)
		return nil, false, false
	}

	if subject == nil {
		return nil, false, true
	}

	return ycauth.PutSubjectToValidInfo(subject, &validator.Info{Type: "YCCookie"}), true, true
}
