package yctoken

import (
	"context"
	"regexp"

	"a.yandex-team.ru/cloud/iam/accessservice/client/iam-access-service-client-go/v1"
	"a.yandex-team.ru/security/ant-secret/web/internal/validator"
	"a.yandex-team.ru/security/ant-secret/web/internal/ycauth"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

var tokenRe = regexp.MustCompile(`^t1\.[A-Z0-9a-z_-]+[=]{0,2}\.[A-Z0-9a-z_-]{86}[=]{0,2}$`)

func Match(ctx validator.Context) bool {
	return tokenRe.MatchString(ctx.Secret)
}

func Validate(ctx validator.Context) (*validator.Info, bool, bool) {
	subject, err := ycauth.Authenticate(context.Background(), cloudauth.NewIAMToken(ctx.Secret))
	if err != nil {
		simplelog.Error("unable to check yc token", "err", err)
		return nil, false, false
	}

	if subject == nil {
		return nil, false, true
	}

	return ycauth.PutSubjectToValidInfo(subject, &validator.Info{Type: "YCToken"}), true, true
}
