'use strict';

(function () {
    const tmpl = _.template(`
<% if (!!ok) { %>
    <div class="container">Похоже, это валидный секретик (<b><%-systemName%></b>)<% if (typeof users != 'undefined' && !!users) { %> <% if (users.indexOf(',') === -1) { %> пользователя <% } else { %> пользователей <% } %> <b><%-users%></b><% } %>.</div>
    <div class="container"><% if (yis_knows) { %>Но узбагойся, СИБ в курсе.<% } %> <%=renderedAlerts%></div>
    <% if (typeof additional_info != 'undefined' && !!additional_info) { %>
        <div class="container">Дополнительная информация:</div>
        <div class="container"><pre>
        <% Object.keys(additional_info).forEach(function(name) {
%><% if (typeof additional_info[name] === 'string') { %><%-name%>: <%-additional_info[name]%><% } else {
%><%-name%>:
<%-JSON.stringify(additional_info[name], null, 2) %><% } %>
        <% }); %></pre></div>
        <% } %>
<% } else { %>
    <div class="container">Не смогла :(</div>
    <div class="container">Это может быть не знакомый нам тип секретов или он уже отозван. <% if (yis_knows) {%> В любом случае, СИБ его уже встречал.<% } %> <%=renderedAlerts%></div>
<% } %>
`);

    const typeToName = {
        YOAuthInternal: 'Yandex OAuth (internal)',
        YOAuthExternal: 'Yandex OAuth (external)',
        GithubInternal: 'Github (internal)',
        GithubExternal: 'Github (external)',
        StaffSSH: 'Staff SSH-key'
    };

    function getHashParams() {
        let hashParams = {};
        let e,
            a = /\+/g,  // Regex for replacing addition symbol with a space
            r = /([^&;=]+)=?([^&;]*)/g,
            d = function (s) {
                return decodeURIComponent(s.replace(a, " "));
            },
            q = window.location.hash.substring(1);

        while (e = r.exec(q))
            hashParams[d(e[1])] = d(e[2]);

        return hashParams;
    }

    function onError() {
        $('#result').html('Произошла какая-то упячка, попробуй позже.');
    }

    function formatSecAlerts(secalerts) {
        if (!secalerts.length) {
            return '';
        }

        return 'Секалерты: ' + secalerts.map(function(alert) {
            return `<a href="https://st.yandex-team.ru/${alert}" target="_blank">${alert}</a>`
        }).join(', ');

    }

    function render(secretInfo) {
        if (typeof secretInfo !== 'object') {
            onError();
            return
        }

        secretInfo['systemName'] = typeToName[secretInfo.type] || secretInfo.type;
        secretInfo['renderedAlerts'] = formatSecAlerts(secretInfo.sec_alerts || []);
        $('#result').html(tmpl(secretInfo));
    }

    function search(secret) {
        $('#result').html("Ищу...");
        $.ajax({
            type: "POST",
            url: '/api/v1/validate',
            dataType: 'json',
            data: {secret},
            success: render,
            error: onError,
        });
    }

    function hideHash() {
        if ('replaceState' in history) {
            history.replaceState('', document.title, window.location.pathname + window.location.search);
        } else {
            window.location.replace('#');
        }
    }

    function checkHash() {
        const params = getHashParams();
        if (!!params.secret) {
            let secret = params.secret;
            hideHash();
            $('form[name="search"] textarea[name="secret"]').val(secret);
            search(secret);
        }
    }

    $(window).bind('hashchange', checkHash);
    $(document).ready(function () {
        checkHash();

        $('form[name="search"]').bind('submit', function (e) {
            e.preventDefault();
            let secret = $('form[name="search"] textarea[name="secret"]').val();
            search(secret);
        });

        $('form[name="search"] textarea[name="secret"]').keypress(function (e) {
            if (e.which === 13 && !e.shiftKey) {
                $(this).closest("form").submit();
                e.preventDefault();
                return false;
            }
        });
    });
})();
