#include <tunables/ycommon>

@{kafka_service}=kafka.service
@{jdk_11}=java-11-openjdk-amd64
@{not_java}={/{?,??,???,?????*},/[^j][^a][^v][^a]}

/opt/kafka/bin/kafka-server-start.sh flags=(complain) {
  #include <abstractions/ycommon>


#bin
  # should: java monitored binaries
  # /usr/lib/jvm/@{jdk_11}/bin/java rCx -> java_kafka,

  # have:   allow any java
  /**/bin/java              rCx -> java_kafka,

  # runner script profile
  /opt/kafka/**       r,
  /opt/kafka/bin/*.sh rix,
  /bin/{,ba,da}sh     rmix,
  /bin/{,e}grep       rmix,
  /bin/mkdir          rmix,
  /bin/sed            rmix,
  /bin/uname          rmix,
  /usr/bin/cut        rmix,
  /usr/bin/dirname    rmix,
  # We must ensure that script that launches java is under root profile for Cx to work properly
  # Actually all launcher scripts must be in /opt/kafka/bin/, but if smth happens, this rule
  # will preserve the ix context and alert us about changes
  /**@{not_java}  ix,

  #JAVA_SPECIFIC
    /  r,

  #UNIX_SPECIFIC
    #lib
      /lib/x86_64-linux-gnu/libc-@{lib_version}.so          r,
      /lib/x86_64-linux-gnu/libdl-@{lib_version}.so         r,
      /lib/x86_64-linux-gnu/libpcre.so.@{lib_version}       r,
      /lib/x86_64-linux-gnu/libpthread-@{lib_version}.so    r,
      /lib/x86_64-linux-gnu/libtinfo.so.@{lib_version}      r,
      /lib/x86_64-linux-gnu/libz.so.@{lib_version}         rm,

    #dev
      /dev/tty            rw,
    #etc
      /etc/ld.so.cache    r,

  profile java_kafka flags=(complain) {
    #include <abstractions/ycommon>

  #CAPABILITIES
    #ipc
    #network&sockets
    #other

  #UNIX_SPECIFIC
    #bin
    #lib
      /lib/x86_64-linux-gnu/ld-@{lib_version}.so                  rm,
      /lib/x86_64-linux-gnu/libc-@{lib_version}.so                rm,
      /lib/x86_64-linux-gnu/libdl-@{lib_version}.so               rm,
      /lib/x86_64-linux-gnu/libm-@{lib_version}.so                rm,
      /lib/x86_64-linux-gnu/libnsl-@{lib_version}.so              rm,
      /lib/x86_64-linux-gnu/libnss_compat-@{lib_version}.so       rm,
      /lib/x86_64-linux-gnu/libnss_files-@{lib_version}.so        rm,
      /lib/x86_64-linux-gnu/libnss_nis-@{lib_version}.so          rm,
      /lib/x86_64-linux-gnu/libpthread-@{lib_version}.so          rm,
      /lib/x86_64-linux-gnu/librt-@{lib_version}.so               rm,
      /lib/x86_64-linux-gnu/libgcc_s.so.@{lib_version}            rm,

    #run
    #proc
      /proc/stat		            r,
      /proc/loadavg		            r,
      owner /proc/@{pid}/status	            r,
      owner /proc/@{pid}/task/@{pid}/stat   r,
      owner /proc/@{pid}/stat	            r,
      owner /proc/@{pid}/io	            r,
      owner /proc/@{pid}/fd/                r,

    #proc/sys
      /proc/sys/kernel/pid_max     r,
      /proc/sys/kernel/threads-max r,
      /proc/sys/vm/max_map_count   r,

    #sys
      /sys/devices/system/cpu/online                              r,
      /sys/fs/cgroup/memory/database.slice/memory.limit_in_bytes  r,
      /sys/fs/cgroup/memory/database.slice/memory.usage_in_bytes  r,
      /sys/fs/cgroup/memory/memory.limit_in_bytes                 r,
      /sys/fs/cgroup/memory/memory.usage_in_bytes                 r,
      /sys/fs/cgroup/cpu,cpuacct/cpu.cfs_quota_us                 r,
      /sys/fs/cgroup/cpu,cpuacct/database.slice/cpu.cfs_period_us r,
      /sys/fs/cgroup/cpu,cpuacct/database.slice/cpu.cfs_quota_us  r,
      /sys/fs/cgroup/cpu,cpuacct/database.slice/cpu.shares        r,
      /sys/fs/cgroup/cpu,cpuacct/database.slice/cpu.stat          r,
      /sys/fs/cgroup/cpu,cpuacct/database.slice/cpuacct.usage     r,
      /sys/fs/cgroup/cpuset/cpuset.cpus                           r,
      /sys/fs/cgroup/cpuset/cpuset.mems                           r,
      /sys/fs/cgroup/*/system.slice/@{kafka_service}/**           r,
    #dev
    #locale
      /usr/lib/locale/locale-archive                       r,
      /usr/lib/x86_64-linux-gnu/gconv/gconv-modules.cache  r,
    #timezones
    #etc
      /etc/hosts          r,
      /etc/host.conf      r,
      /etc/gai.conf       r,
      /etc/*java*/**      r,
      /etc/nsswitch.conf  r,
      /etc/ld.so.cache    r,
      /etc/passwd         r,
      /etc/resolv.conf    r,
      /etc/timezone       r,


  #JAVA_SPECIFIC
      /                               r,
      /usr/lib/jvm/@{jdk_11}/bin/java mr,
      /usr/lib/jvm/@{jdk_11}/conf/**  r,
      /usr/lib/jvm/@{jdk_11}/lib/**   mr,


  #SERVICE_SPECIFIC
    #conf
      /etc/kafka/jmxremote.access            r,
      /etc/kafka/prometheus_jmx_exporter.yml r,
      /etc/kafka/server.properties           r,
      /opt/kafka/config/log4j.properties     r,
    #bin
    #libs
      /opt/kafka/libs/snappy-java-@{lib_version}.jar                  r,
      /opt/kafka/libs/trogdor-@{lib_version}.jar                      r,
      /opt/kafka/libs/jetty-util-@{lib_version}.jar                   r,
      /opt/kafka/libs/jetty-util-ajax-@{lib_version}.jar              r,
      /opt/kafka/libs/activation-@{lib_version}.jar                   r,
      /opt/kafka/libs/aopalliance-repackaged-@{lib_version}.jar       r,
      /opt/kafka/libs/argparse4j-@{lib_version}.jar                   r,
      /opt/kafka/libs/audience-annotations-@{lib_version}.jar         r,
      /opt/kafka/libs/commons-cli-@{lib_version}.jar                  r,
      /opt/kafka/libs/commons-lang3-@{lib_version}.jar                r,
      /opt/kafka/libs/connect-api-@{lib_version}.jar                  r,
      /opt/kafka/libs/connect-basic-auth-extension-@{lib_version}.jar r,
    #logs
      owner /var/log/kafka/controller.log*     rw,
      owner /var/log/kafka/kafkaServer-gc.log* rw,
      owner /var/log/kafka/log-cleaner.log*    rw,
      owner /var/log/kafka/state-change.log*   rw,
      owner /var/log/kafka/kafka-authorizer*   rw,
    #tmp
    #secrets,certs
      /etc/kafka/jmxremote.password            rk,
      /etc/kafka/kafka_server_jaas.conf        r,
      /etc/kafka/ssl/server.keystore.jks       r,
      /etc/kafka/ssl/server.truststore.jks     r,
      /etc/ssl/certs/java/cacerts              r,
    #other
      # /var/lib/kafka/ - kafka logs.dir (datafiles, locks)
      /var/lib/kafka/                          r,
      /var/lib/kafka/.lock                     rwk,
      owner /var/lib/kafka/**                  rw,
  }
}
