#include <tunables/ycommon>

# ch and kafka use different dataDir for its zookeepers
  # ch: /data
  # kafka: /data/zookeeper
alias /data/ -> /data/zookeeper/,

/usr/lib/jvm/java-11-openjdk-amd64/bin/java-zookeeper flags=(complain) {
  #include <abstractions/ycommon>

#UNIX_SPECIFIC
  #bin
    /lib/x86_64-linux-gnu/* rix,
    /usr/lib/x86_64-linux-gnu/* rix,
  #lib
  #run
  #proc
    /proc/cpuinfo r,
    /proc/loadavg r,
    owner /proc/@{pid}/ r,
    owner /proc/@{pid}/** r,
    /proc/@{pid}/net/if_inet6 r,
    /proc/@{pid}/net/ipv6_route r,
    /proc/meminfo r,
    /proc/filesystems r,
    /proc/sys/vm/overcommit_memory r,
    /proc/sys/net/ipv4/ip_local_port_range r,
    owner /proc/@{pid}/coredump_filter w,
    /proc/stat r,
  #sys
    /sys/devices/system/cpu/ r,
    /sys/devices/system/cpu/online r,
  #dev
    /dev/random r,
    /dev/urandom r,
  #locale
    /etc/locale.alias r,
    /usr/lib/locale/locale-archive r,
  #timezones
    /usr/share/zoneinfo/* r,
  #etc
    /etc/lsb-release r,
    /etc/hosts r,
    /etc/passwd r,
    /etc/timezone r,
    /etc/gai.conf r,
    /etc/host.conf r,
    /etc/ld.so.cache r,
    /etc/resolv.conf r,
    /etc/zookeeper/** r,
    /etc/nsswitch.conf r,
    /etc/java-11-openjdk/** r,

#JAVA_SPECIFIC
    /sys/fs/cgroup/** r,
    /usr/share/java/* r,
    /usr/lib/jvm/java-11-openjdk-amd64/lib/** rix,
    /etc/ssl/certs/java/cacerts r,
    /proc/sys/net/ipv4/tcp_fastopen r,
    /proc/sys/net/core/somaxconn r,
    /usr/lib/jvm/java-11-openjdk-amd64/conf/security/policy/unlimited/ r,
    /usr/lib/jvm/java-11-openjdk-amd64/conf/security/policy/unlimited/** r,

#SERVICE_SPECIFIC
    / r,
  #libs
    /usr/lib/os-release          r,
    /usr/lib/zookeeper/lib/*.jar r,
    /var/lib/zookeeper/ r,
    /var/lib/zookeeper/myid r,
    /var/lib/zookeeper/version-2/ rw,
    /var/lib/zookeeper/version-2/* rw,
    # ZooKeeper extracts this library from netty-all-*.jar file
    owner /tmp/libnetty_transport_native_epoll_x86*.so rwm,

    # data path can be overridden by alias instruction above
    /data/           r,
    /data/version-2/ r,
    owner /data/myid r,
    owner /data/version-2/acceptedEpoch{,.tmp} wr,
    owner /data/version-2/currentEpoch{,.tmp}  wr,
    owner /data/version-2/log.*                wr,
    owner /data/version-2/snapshot.*           wr,
    owner /etc/zookeeper/conf.yandex/zoo*      w,
  #logs
    owner /var/log/zookeeper/gc.log* rw,
    owner /var/log/zookeeper/zookeeper.log* rw,
  #JVM OOM dumps
    owner /var/log/zookeeper/hs_err_pid*.log    wr,
    /proc/sys/kernel/core_pattern               r,
    /proc/sys/kernel/pid_max                    r,
    /proc/sys/kernel/threads-max                r,
    /proc/sys/vm/max_map_count                  r,
    /sys/devices/system/cpu/offline             r,
    /sys/kernel/mm/transparent_hugepage/defrag  r,
    /sys/kernel/mm/transparent_hugepage/enabled r,
  #tmp
    owner /tmp/hsperfdata_zookeeper/ rw,
    owner /tmp/hsperfdata_zookeeper/* rw,
    owner /tmp/hsperfdata_root/ rw,
    owner /tmp/hsperfdata_root/* rw,
    owner /tmp/hs_err_pid@{pid}.log rw,
  #other
    owner /hs_err_pid@{pid}.log rw,
}
