#include <tunables/ycommon>

/Berkanavt/solomon/gateway/run.sh flags=(complain) {
  #include <abstractions/ycommon>

#CAPABILITIES
  #ipc
    signal send peer=/Berkanavt/solomon/gateway/run.sh,
    signal receive peer=/Berkanavt/solomon/gateway/run.sh,
    signal (receive) set=("cont", "term", "exists", "usr2") peer=unconfined,
  #network&sockets
  #other
    ptrace (trace, tracedby) peer="/Berkanavt/solomon/gateway/run.sh",

#UNIX_SPECIFIC
  #bin
    /bin/readlink rix,
    /usr/bin/dirname rix,
    /bin/hostname rix,
    /usr/local/jdk-15/bin/java rix,
    /usr/local/jdk-16/bin/java rix,
    /usr/bin/getconf rix,
  #lib
    /usr/lib/os-release r,
    /usr/lib/x86_64-linux-gnu/gconv/gconv-modules.cache r,
    /lib/x86_64-linux-gnu/libc-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libdl-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libm-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libnss_compat-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libnss_files-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libnss_nis-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libpthread-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/librt-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libz.so.@{lib_version} rm,
    /lib/x86_64-linux-gnu/libnsl-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libtinfo.so.@{lib_version} rm,
    /lib/x86_64-linux-gnu/libthread_db-@{lib_version}.so rm,
    # grpc-default-ex
    /lib/x86_64-linux-gnu/libnss_dns-@{lib_version}.so rm,
    /lib/x86_64-linux-gnu/libresolv-@{lib_version}.so rm,
  #run
  #proc
    /proc/ r,
    /proc/stat r,
    /proc/@{pid}/stat r,
    /proc/@{pid}/net/dev r,
    /proc/@{pid}/stat r,
    /proc/@{pid}/cgroup r,
    /proc/@{pid}/mountinfo r,
    /proc/@{pid}/net/if_inet6 r,
    /proc/@{pid}/net/ipv6_route r,
    /proc/@{pid}/fd/ r,
    /proc/@{pid}/maps r,
    /proc/@{pid}/coredump_filter rw,
    /proc/meminfo r,
    /proc/vmstat r,
    /proc/sys/net/core/somaxconn r,
    /proc/sys/net/ipv4/tcp_fastopen r,
    /proc/sys/vm/overcommit_memory r,
    /proc/cpuinfo r,
    /proc/cgroups r,
    /proc/loadavg r,
    /proc/sys/kernel/core_pattern r,
    /proc/sys/kernel/pid_max r,
    /proc/sys/kernel/threads-max r,
    /proc/sys/vm/max_map_count r,
  #sys
    /sys/fs/cgroup/cpuset/cpuset.cpus r,
    /sys/fs/cgroup/cpuset/cpuset.mems r,
    /sys/fs/cgroup/memory/system.slice/yandex-solomon-gateway.service/memory.use_hierarchy r,
    /sys/fs/cgroup/memory/system.slice/yandex-solomon-gateway.service/memory.max_usage_in_bytes r,
    /sys/fs/cgroup/memory/system.slice/yandex-solomon-gateway.service/memory.soft_limit_in_bytes r,
    /sys/fs/cgroup/memory/system.slice/yandex-solomon-gateway.service/memory.limit_in_bytes r,
    /sys/fs/cgroup/memory/system.slice/yandex-solomon-gateway.service/memory.usage_in_bytes r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/yandex-solomon-gateway.service/cpu.cfs_period_us r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/yandex-solomon-gateway.service/cpu.cfs_quota_us r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/yandex-solomon-gateway.service/cpu.shares r,
    /sys/fs/cgroup/memory/user.slice/memory.limit_in_bytes r,
    /sys/devices/system/cpu/ r,
    /sys/devices/system/cpu/online r,
  #dev
    /dev/tty    wr,
  #locale
  #timezones
  #etc
    /etc/hosts r,
    /etc/ld.so.cache r,
    /etc/resolv.conf r,
    /etc/gai.conf r,
    /etc/host.conf r,
    /etc/nsswitch.conf r,
    /etc/passwd r,
    /etc/timezone r,
    /etc/yandex/environment.type r,
    /etc/solomon/env r,
    /etc/solomon/dc r,
    /etc/lsb-release r,
    /etc/yc/ssl/certs/ca-certs-jks r,

#JAVA_SPECIFIC
    /usr/local/jdk-15/conf/** r,
    /usr/local/jdk-15/bin/java r,
    /usr/local/jdk-15/lib/** r,
    /usr/local/jdk-15/lib/**.so mr,
    /usr/local/jdk-15/lib/jspawnhelper rix,
    /usr/local/jdk-15/lib/server/classes.jsa rm,
    /usr/local/jdk-16/conf/** r,
    /usr/local/jdk-16/bin/java r,
    /usr/local/jdk-16/lib/** r,
    /usr/local/jdk-16/lib/**.so mr,

#SERVICE_SPECIFIC
  #conf
    /Berkanavt/solomon/configs/gateway.*.conf r,
    /etc/solomon/team.* r,
  #bin
  #libs
  #logs
    /Berkanavt/solomon/gateway/hs_err_pid@{pid}.log rw,
    /Berkanavt/solomon/gateway/gateway-gc.log*       w,
    owner /logs/gateway-gc.log                       r,
    owner /logs/gateway-safepoints.log               r,
    owner /Berkanavt/solomon/logs/*                  w,
    owner /logs/**                                   w,
  #tmp
    /var/tmp/ r,
    owner /var/tmp/* wr,
    owner /tmp/hsperfdata_user_gateway/ r,
    owner /tmp/hsperfdata_user_gateway/* wr,
    owner /var/tmp/libnetty_transport_native_epoll_x86_*.so rwm,
    owner /var/tmp/libnative-linux-amd64.so-* rwm,
    owner /var/tmp/libposix-linux-amd64.so-* rwm,
    owner /var/tmp/libzstd-*.so rwm,
    owner /var/tmp/tomcat** wrl,
    owner /var/tmp/liblz4-java*.so m,
  #secrets,certs
    /Berkanavt/keys/solomon/gateway-compute.pem r,
    /Berkanavt/keys/solomon/ui-request-secret   r,
    /Berkanavt/keys/solomon/iam.pem             r,
    /Berkanavt/keys/solomon/ydb_global_iam.pem  r,
    /Berkanavt/solomon/secrets/*.secrets        r,
  #caches
    owner /Berkanavt/solomon/gateway/conductor_cache/*.txt rw,
    owner /Berkanavt/solomon/gateway/cache/* rw,
  #other
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.MF r,
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.css r,
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.png r,
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.svg r,
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.html r,
    /Berkanavt/solomon/gateway/solomon-gateway/webapp/**.js r,
    /Berkanavt/solomon/gateway/ r,
    /Berkanavt/solomon/gateway/libs/ r,
    /Berkanavt/solomon/gateway/libs/* r,
    /Berkanavt/solomon/etc/java.sh r,
    /Berkanavt/solomon/etc/memory.sh r,
    /Berkanavt/solomon/gateway/run.sh r,
    /Berkanavt/solomon/gateway/vmoptions.sh r,
    /usr/bin/dirname r,
    /usr/lib/locale/locale-archive r,
}
