#include <tunables/ycommon>
@{user1}=yql
@{jdk_11}=jdk-11
@{yql_service}=yandex-yql-api.service

/Berkanavt/yql/api-service/run.sh flags=(complain) {
  #include <abstractions/ycommon>

#CAPABILITIES
  #ipc
    signal receive,
  #network&sockets
    network inet6 stream,
    network inet6 dgram,
    network inet stream,
    network inet dgram,
    network netlink raw,
    unix create,
    unix shutdown,

#UNIX_SPECIFIC
  #bin
    /usr/bin/dirname rix,
    /usr/bin/find rix,
    /usr/bin/tr rix,
    /bin/readlink rix,
    /lib/x86_64-linux-gnu/* rix,
  #lib
    /usr/lib/locale/locale-archive r,
    /usr/lib/x86_64-linux-gnu/gconv/gconv-modules.cache r,
    /usr/lib/os-release r,
  #run
    /run/resolvconf/resolv.conf r,
    /run/systemd/resolve/stub-resolv.conf r,
  #proc
    owner /proc/@{pid}/ r,
    owner /proc/@{pid}/cgroup r,
    owner /proc/@{pid}/coredump_filter wr,
    owner /proc/@{pid}/maps r,
    owner /proc/@{pid}/mountinfo r,
    /proc/@{pid}/net/if_inet6 r,
    /proc/@{pid}/net/ipv6_route r,
    /proc/filesystems r,
    /proc/stat r,
    /proc/sys/net/core/somaxconn r,
    /proc/sys/net/ipv4/tcp_fastopen r,
    /proc/sys/vm/overcommit_memory r,
  #sys
    /sys/devices/system/cpu/ r,
    /sys/devices/system/cpu/online r,
    /sys/fs/cgroup/memory/memory.limit_in_bytes r,
    /sys/fs/cgroup/cpu,cpuacct/cpu.cfs_quota_us r,
    /sys/fs/cgroup/cpu,cpuacct/cpu.cfs_period_us r,
    /sys/fs/cgroup/cpu,cpuacct/cpu.shares r,
    /sys/fs/cgroup/memory/system.slice/@{yql_service}/memory.limit_in_bytes r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/@{yql_service}/cpu.cfs_quota_us r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/@{yql_service}/cpu.cfs_period_us r,
    /sys/fs/cgroup/cpu,cpuacct/system.slice/@{yql_service}/cpu.shares r,
  #dev
    /dev/random r,
    /dev/urandom r,
  #timezones
    /usr/share/zoneinfo/ r,
    /usr/share/zoneinfo/** r,
  #etc
    /etc/locale.alias r,
    /etc/hosts r,
    /etc/gai.conf r,
    /etc/hosts.conf r,
    /etc/ld.so.cache r,
    /etc/host.conf r,
    /etc/protocols r,
    /etc/nsswitch.conf r,
    /etc/passwd r,

#JAVA_SPECIFIC
    /usr/local/@{jdk_11}/bin/java rix,
    /usr/local/@{jdk_11}/conf/** r,
    /usr/local/@{jdk_11}/lib/** mr,

#SERVICE_SPECIFIC
    / r,
    /Berkanavt/yql/api-service/libs/** r,
    /Berkanavt/yql/api-service/libs/ r,
    /Berkanavt/yql/api-service/ r,
    /Berkanavt/yql/api-service/etc/* r,
    /Berkanavt/yql/api-service/logs/* r,
    /Berkanavt/yql/cfg/cloud-test/* r,
    /Berkanavt/yql/cfg/current/api.conf r,
    /Berkanavt/yql/cfg/cloud/api.conf r,
    /Berkanavt/yql/cfg/cloud-preprod/api.conf r,
    /Berkanavt/yql/cfg/cloud-preprod/worker.conf r,
    /Berkanavt/yql/cfg/cloud-internal/api.conf r,
    /Berkanavt/yql/cfg/cloud-internal/worker.conf r,
    /Berkanavt/yql/cfg/cloud/worker.conf r,
    /Berkanavt/yql/cfg/current/worker.conf r,
    /Berkanavt/yql/api-service/run.sh r,
    /home/yql/ rw,
    /home/@{user1}/.oracle_jre_usage/ rw,
    /home/@{user1}/.oracle_jre_usage/*.timestamp rw,
  #logs
    /Berkanavt/yql/api-service/logs/access.log w,
    /Berkanavt/yql/api-service/logs/service.log w,
  #tmp
    /tmp/hsperfdata_@{user1}/ rw,
    /tmp/hsperfdata_@{user1}/@{pid} rw,
    /var/tmp/ r,
    /var/tmp/keyutil_example.com_[0-9]*.key rw,
    /var/tmp/keyutil_example.com_[0-9]*.crt rw,
    /var/tmp/libnative-linux-amd64.so-[0-9]* rwm,
    /var/tmp/libnetty_tcnative_linux_x86_[0-9]*.so rwm,
    /var/tmp/libnetty_transport_native_epoll_x86_[0-9]*.so rwm,
    /var/tmp/libposix-linux-amd64.so-[0-9]* rwm,
}
