from flask import request
from flask_restplus import Resource
from app.api import api
from app.api.for_collectors.business import add_object_to_project

ns = api.namespace('for_collectors', description = 'Operations from collectors')


@ns.route('/add')
class OrganizationProjectObjectImport(Resource):

    def post(self):
        """
        Import information from collectors
        [{
            "project_id":1,
            "objects":[{
                "uuid":"96e4f4187c367db042620b8d130bf4a2",
                "type":"person",
                "value":"aleksei-m",
                "fields":{
                        "name": {
                            "en": "Aleksei Meshcheriakov",
                            "ru": "Алексей Мещеряков"
                        }
                    },
                "ancestors":[]
            }]
        }]
        """
        data = request.json
        for project in data:
            add_object_to_project(project['project_id'], project['objects'])
        return {"message": "OK"}, 200