from app.database import db
from app.database.project import Project
from app.database.object import Object
from flask import url_for
from sqlalchemy import or_

def get_ancestors_by_type(child_object, ancestor_type):
    result_ancestors = []
    checked_ancestors = set()
    ancestors_uuids = child_object.ancestors
    while ancestors_uuids:
        ancestors = db.session.query(Object).filter(Object.uuid.in_(set(ancestors_uuids))).all()
        checked_ancestors.update(ancestors_uuids)
        ancestors_uuids = []
        for ancestor in ancestors:
            if ancestor.type == ancestor_type:
                result_ancestors.append(ancestor)
            else:
                checked_ancestors.add(ancestor.uuid)
                for ancestor_uuid in ancestor.ancestors:
                    if ancestor_uuid not in checked_ancestors:
                        ancestors_uuids.append(ancestor_uuid)
    return result_ancestors


def search_child_objects(parent_type, parent_field_name, parent_field_value, child_type, recursive=True):
    parent_object = db.session.query(Object).filter(
        Object.type == parent_type, Object.fields[parent_field_name].astext == parent_field_value
    ).first_or_404()
    all_child_objects = db.session.query(Object).filter(
        Object.type == child_type, Object.project_id == parent_object.project_id
    ).all()
    child_objects = []
    if recursive:
        for child_object in all_child_objects:
            ancestor_objects = get_ancestors_by_type(child_object, parent_type)
            if parent_object.uuid in map(lambda obj: obj.uuid, ancestor_objects):
                child_objects.append(child_object)
    else:
        for child_object in all_child_objects:
            ancestors_uuids = child_object.ancestors
            if parent_object.uuid in ancestors_uuids:
                child_objects.append(child_object)
    return child_objects


def search_ancestor_object(child_type, ancestor_type, child_value="", child_field_name="", child_field_value=""):
    if child_value:
        child_object = db.session.query(Object).filter(
            Object.type == child_type, Object.value == child_value
        ).first_or_404()
    else:
        child_object = db.session.query(Object).filter(
            Object.type == child_type, Object.fields[child_field_name].astext == child_field_value
        ).first_or_404()
    ancestors = get_ancestors_by_type(child_object, ancestor_type)
    return ancestors


def search_objects(project_id_or_slug, start_date="", finish_date="", event_type="", checked=None):
    if project_id_or_slug.isdigit():
        project = db.session.query(Project).filter(Project.id == project_id_or_slug).first_or_404()
    else:
        project = db.session.query(Project).filter(Project.slug == project_id_or_slug).first_or_404()
    query = db.session.query(Object).filter(Object.project_id == project.id)
    if start_date:
        query = query.filter(Object.added_at >= start_date)
    if finish_date:
        query = query.filter(Object.added_at <= finish_date)
    if event_type:
        query = query.filter(Object.type == event_type)
    if checked is not None:
        query = query.filter(Object.checked == checked)
    objects = query.all()
    return [{"href":url_for('ui.view_object', project_id=object.project_id, object_uuid=object.uuid, _external=True),
             "description":str(object)} for object in objects]