from flask import g

from sqlalchemy import or_
from sqlalchemy import and_

from app.database import db
from app.database.user import User
from app.database.organization import Organization
from app.database.project import Project
from app.database.object import Object

from app.api.for_services.business import search_objects


def show_all_organizations_for_current_user():
    user_roles = User.query.filter(User.login == g.yalogin).all()
    user_view_filters = []
    show_all = False
    for user_role in user_roles:
        if user_role.organization_slug == '*':
            user_view_filters = []
            show_all = True
            break
        else:
            user_view_filters.append(Organization.slug.ilike(user_role.organization_slug))
    if show_all:
        organizations = Organization.query.order_by(Organization.name).all()
    else:
        organizations = Organization.query.filter(or_(*user_view_filters)).order_by(Organization.name).all()
    return organizations


def show_projects_for_current_user(organization_id):
    organization = Organization.query.filter_by(id=organization_id).first()
    user_roles = User.query.filter(and_(User.login == g.yalogin,
                                        or_(User.organization_slug == '*',
                                            User.organization_slug == organization.slug))).all()
    user_view_filters = []
    show_all = False
    for user_role in user_roles:
        if user_role.organization_slug == '*' or user_role.project_slug == '*':
            user_view_filters = []
            show_all = True
            break
        else:
            user_view_filters.append(Project.slug.ilike(user_role.project_slug))
    if show_all:
        projects = Project.query.filter(Project.organization_id == organization.id).order_by(Project.name).all()
    else:
        projects = Project.query.filter(Project.organization_id == organization.id).filter(or_(*user_view_filters)).order_by(Project.name).all()
    return projects


def search_objects_for_current_user(project_id, start_date=None, finish_date=None):
    project = Project.query.filter_by(id=project_id).first()
    user_roles = User.query.filter(and_(User.login == g.yalogin,
                                        or_(User.organization_slug == '*',
                                            and_(User.organization_slug == project.organization.slug,
                                                 or_(User.project_slug == '*',
                                                     User.project_slug == project.slug))
                                            ))).all()
    if len(user_roles) > 0:
        query = db.session.query(Object).filter(Object.project_id == project.id)
        if start_date:
            query = query.filter(Object.added_at >= start_date)
        if finish_date:
            query = query.filter(Object.added_at <= finish_date)
        objects = query.all()
        return [object.to_json() for object in objects]
    else:
        return None
