from flask import jsonify
from flask import request
from flask import abort

from app import yauth
from app.api.v1 import apiv1 as api

from app.api.v1.bussiness import show_all_organizations_for_current_user
from app.api.v1.bussiness import show_projects_for_current_user
from app.api.v1.bussiness import search_objects_for_current_user

@api.route("/organizations")
@yauth.sessionid_required
@yauth.idm_role_required('admin', 'security', 'read')
def organizations_list():
    result = []
    organizations = show_all_organizations_for_current_user()
    for organization in organizations:
        dict_organization = organization.to_dict()
        projects = show_projects_for_current_user(organization.id)
        dict_organization['projects'] = [project.to_dict() for project in projects]
        result.append(dict_organization)
    return jsonify(result)

@api.route("/projects/<project_id>/events")
@yauth.sessionid_required
@yauth.idm_role_required('admin', 'security', 'read')
def events_list(project_id):
    start_date = request.args.get('start_date', default=None)
    finish_date = request.args.get('finish_date', default=None)
    results = search_objects_for_current_user(project_id, start_date, finish_date)
    if results is not None:
        return jsonify(results)
    else:
        abort(403)
