from app.database.object import Object


class Commit(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'commit'
    }

    def __repr__(self):
        vcs = self.fields.get('vcs', '')
        if vcs == 'github':
            owner = self.fields.get('owner', '')
            repo = self.fields.get('repo', '')
            changed = len(self.fields.get('files', []))
            title = '[github] {}/{} {} files changed'.format(owner, repo, changed)
            return title
        else:
            return str(self.value)

    def href_link(self):
        if self.fields.get('html_url'):
            return str(self.fields['html_url'])
        elif self.fields.get('url'):
            return str(self.fields['url'])
        else:
            return "#"

    def full_info(self):
        result = []
        owner = self.fields.get('owner', '')
        repo = self.fields.get('repo', '')
        vcs = self.fields.get('vcs', '')

        if vcs == 'github':
            repo_url = 'https://github.yandex-team.ru/{}/{}'.format(owner, repo)
        else:
            repo_url = self.value
        result.append(('Repo', dict(url=repo_url, text=repo_url)))

        if self.fields.get('branch'):
            result.append(('Branch', self.fields['branch']))

        if self.fields.get('author'):
            result.append(('Author', self.fields['author']))

        if self.fields.get('files'):
            result.append(('Files', self.fields['files']))

        if self.fields.get('stats'):
            additions = self.fields['stats'].get('additions', 0)
            deletions = self.fields['stats'].get('deletions', 0)
            result.append(('Additions stat', additions))
            result.append(('Deletions stat', deletions))

        result += super().full_info(set(['vcs', 'owner', 'repo', 'branch', 'author',
                                        'files', 'stats', 'url', 'html_url', 'date']))
        return result

    @staticmethod
    def feed_color():
        return '#b3deff'
