from app import db
from app.database.object import Object
import json


class Handle(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'handle'
    }

    def __repr__(self):
        if self.fields.get('handle'):
            return str(self.fields.get('handle'))
        else:
            return str(self.value)

    def href_link(self):
        if self.fields.get("repo"):
            if str(self.fields.get("repo")).startswith("https://github"):
                branch = "master"
                if self.fields.get("branch"):
                    branch = self.fields.get("branch")
                path = ""
                if self.fields.get("path"):
                    path = self.fields.get("path")
                # https://github.yandex-team.ru/taxi/backend-cpp/blob/master/core-engine/config/templates/fastcgi.conf.tpl
                return self.fields.get("repo") + "/blob/" + branch + "/" + self.fields.get("path")
            elif str(self.fields.get("repo")).startswith("https://bb.yandex-team.ru"):
                repo_list = str(self.fields.get("repo")).split('/')[3:]
                project_name = repo_list[0]
                repo_name = repo_list[1]
                branch = ""
                if self.fields.get("branch"):
                    branch = "refs%2Fheads%2F" + self.fields.get("branch")
                path = ""
                if self.fields.get("path"):
                    path = self.fields.get("path")
                # https://bb.yandex-team.ru/projects/EDA/repos/backend_core/browse/src/AdminBundle/Controller/Promo/PromosController.php
                return "https://bb.yandex-team.ru/projects/" + project_name.strip("/") + "/repos/" + repo_name.strip("/") + \
                       "/browse/" + path.strip("/") + "?at=" + branch
            else:
                return str(self.fields.get("repo"))
        else:
            return "#"

    def full_info(self):
        result = []
        if self.fields.get('handle'):
            result.append(('Handle', self.fields.get('handle')))
        if self.fields.get('pattern'):
            result.append(('Pattern', self.fields.get('pattern')))
        if self.fields.get('method'):
            result.append(('Method', self.fields.get('method')))
        if self.fields.get('path'):
            result.append(('Path', self.fields.get('path')))
        if self.fields.get('repo'):
            result.append(('Repo', {
                'url': str(self.fields['repo']),
                'text': str(self.fields['repo'])
            }))
        if self.fields.get('branch'):
            result.append(('Branch', self.fields.get('branch')))
        if self.fields.get('description'):
            result.append(('Description', self.fields.get('description')))
        return result

    @staticmethod
    def feed_color():
        return '#fdff9f'

    @staticmethod
    def template_name():
        return 'handle.html'

    def get_curl_list(self):
        curl_cmd_list = []
        hosts_list = []
        for ancestor in db.session.query(Object).filter(Object.uuid.in_(self.ancestors)):
            if ancestor.fields.get('hosts'):
                if isinstance(ancestor.fields.get('hosts'), list):
                    for hostname in ancestor.fields.get('hosts'):
                        hosts_list.append(hostname['hostname'])
        for hostname in hosts_list:
            curl_cmd = 'curl -vk '
            if self.fields.get('method'):
                curl_cmd += ' -X '+self.fields.get('method')+' '
            post_parameters = []
            get_parameters = []
            header_parameters = []
            if self.fields.get('parameters'):
                parameters = self.fields.get('parameters')
                if isinstance(parameters, list):
                    for parameter in parameters:
                        if parameter.get('in') == 'header':
                            header_parameters.append(' \''+parameter.get('name')+': '
                                                     +parameter.get('default','')+'\'')
                        elif parameter.get('in') == 'body':
                            if parameter.get('schema') and isinstance(parameter['schema'], dict):
                                parameter_schema = parameter.get('schema')
                                if 'properties' in parameter_schema and isinstance(parameter_schema['properties'], dict):
                                    result_json = {}
                                    for prop_name in parameter_schema['properties'].keys():
                                        result_json[prop_name] = parameter_schema['properties'][prop_name].get('default', '') \
                                            if isinstance(parameter_schema['properties'][prop_name], dict) else ''
                                    post_parameters.append(json.dumps(result_json))
                                else:
                                    post_parameters.append(str(parameter.get('schema')))
                            else:
                                post_parameters.append(parameter.get('name', '')+'='+str(parameter.get('default', '')))
                        elif parameter.get('in') == 'query':
                            get_parameters.append(parameter.get('name', '')+'='+str(parameter.get('default', '')))
            if len(header_parameters) > 0:
                curl_cmd += ' '.join([' -H '+header+' ' for header in header_parameters])
            if len(post_parameters) > 0:
                curl_cmd += '-d \''+'&'.join(post_parameters)+'\' '
            curl_cmd += ' \'http://' + hostname + self.fields.get('path')
            if not curl_cmd.endswith('?'): curl_cmd += '?'
            curl_cmd += '&'.join(get_parameters)
            curl_cmd += '\' '
            curl_cmd_list.append(curl_cmd)
        return curl_cmd_list