from app import db
from sqlalchemy.dialects.postgresql import JSON
from datetime import datetime

class Object(db.Model):
    __tablename__ = "objects"

    id = db.Column(db.Integer, primary_key=True)
    uuid = db.Column(db.String(32), unique=True)
    type = db.Column(db.String(20))
    created_at = db.Column(db.DateTime, default=datetime.now())
    updated_at = db.Column(db.DateTime, default=datetime.now())
    added_at = db.Column(db.DateTime, default=datetime.now())
    project_id = db.Column(db.Integer, db.ForeignKey('projects.id'))
    project = db.relationship("Project", back_populates="objects")
    value = db.Column(db.String(255))
    fields = db.Column(JSON)
    ancestors = db.Column(JSON)
    checked = db.Column(db.Boolean, default=False)
    last_checked_by = db.Column(db.String(256))

    __mapper_args__ = {
        'polymorphic_on': type,
    }

    def __init__(self, uuid, type, project_id, fields, value = "", ancestors = [], created_at = None,
                 updated_at = None, added_at = None, checked = False, last_checked_by = ''):
        self.uuid = uuid
        self.type = type
        self.project_id = project_id
        self.fields = fields
        self.value = value
        self.ancestors = ancestors
        self.created_at = created_at if created_at else datetime.now()
        self.updated_at = updated_at if updated_at else datetime.now()
        self.added_at = added_at if added_at else datetime.now()
        self.checked = checked
        self.last_checked_by = last_checked_by

    def __repr__(self):
        return str(self.value)

    def href_link(self):
        return '/object/' + self.uuid + '/show'

    def to_json(self):
        return {
            "uuid": self.uuid,
            "type": self.type,
            "fields": self.fields,
            "value": self.value
        }

    def full_info(self, already_show_fields=set()):
        result = []
        if not self.fields:
            result = [('value',self.value)]
        for field in self.fields:
            if field not in already_show_fields:
                result.append((field, self.fields[field]))
        return result

    @staticmethod
    def feed_color():
        return '#f5f5f5'

    @staticmethod
    def template_name():
        return 'object.html'

    def get_childs(self):
        return []