from app import db
import string, random


class Organization(db.Model):
    __tablename__ = 'organizations'

    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String())
    slug = db.Column(db.String(), unique=True)
    apikey = db.Column(db.String())
    projects = db.relationship("Project", back_populates="organization")

    def __init__(self, name, slug, apikey = None):
        self.name = name
        self.slug = slug
        if apikey:
            self.apikey = apikey
        else:
            self.apikey = ''.join(random.choice(string.ascii_lowercase) for _ in range(64))

    def to_dict(self):
        return {"id": self.id,
                "name": self.name,
                "slug": self.slug
                }