from app import db
from app.database.object import Object

class Project(db.Model):
    __tablename__ = "projects"

    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String())
    slug = db.Column(db.String(), unique=True)
    organization_id = db.Column(db.Integer, db.ForeignKey('organizations.id'))
    enable_notifications = db.Column(db.Boolean)
    st_issue = db.Column(db.String())
    organization = db.relationship("Organization", back_populates="projects")
    schedulers = db.relationship("Scheduler", back_populates="project")

    objects = db.relationship("Object", back_populates="project", lazy='dynamic')
    persons = db.relationship("Person", back_populates="project", lazy='dynamic')
    services = db.relationship("Service", back_populates="project", lazy='dynamic')
    queues = db.relationship("Queue", back_populates="project", lazy='dynamic')
    repositories = db.relationship("Repository", back_populates="project", lazy='dynamic')
    commits = db.relationship("Commit", back_populates="project", lazy='dynamic')
    releases = db.relationship("Release", back_populates="project", lazy='dynamic')
    handles = db.relationship("Handle", back_populates="project", lazy='dynamic')
    resources = db.relationship("Resource", back_populates="project", lazy='dynamic')

    def __init__(self, name, slug, organization_id, enable_notifications, st_issue):
        self.name = name
        self.slug = slug
        self.organization_id = organization_id
        self.enable_notifications = enable_notifications
        self.st_issue = st_issue

    def to_dict(self):
        return {
            "id": self.id,
            "name": self.name,
            "slug": self.slug,
            "organization_id": self.organization_id,
            "enable_notifications": self.enable_notifications,
            "st_issue": self.st_issue
        }
