from app import db
from app.database.object import Object


class Queue(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'queue'
    }

    def __repr__(self):
        if "name" in self.fields:
            return str(self.fields['name'])
        else:
            return str(self.value)

    def href_link(self):
        return "https://st.yandex-team.ru/"+str(self.value)

    def full_info(self):
        result = [('Key', self.value)]
        if "name" in self.fields: result.append(('Name', self.fields["name"]))
        if "name" in self.fields: result.append(('Lead', self.fields["lead"]))
        return result
