from app.database.object import Object


class Release(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'release'
    }

    def __repr__(self):
        if self.fields.get('key') and self.fields.get('summary'):
            return str(self.fields.get('key')) + " - " + str(self.fields.get('summary'))
        return str(self.value)

    def href_link(self):
        if self.fields.get('key'):
            return "https://st.yandex-team.ru/" + str(self.fields['key'])
        elif self.fields.get('release_ticket'):
            return "https://c.yandex-team.ru/tickets/" + str(self.fields['release_ticket'])
        elif self.fields.get('tsum_project_id') and self.fields.get('release_id'):
            return "https://tsum.yandex-team.ru/pipe/projects/" + str(self.fields['tsum_project_id']) + "/release/" + str(self.fields['release_id'])
        else:
            return "#"

    def full_info(self):
        result = []
        if self.fields.get('key'):
            result.append(('TaxiRel Ticket', {
                'url': "https://st.yandex-team.ru/" + str(self.fields['key']),
                'text': str(self.fields['key'])
            }))
        if self.fields.get('summary'):
            result.append(('TaxiRel Ticket Summary', str(self.fields.get('summary'))))
        if self.fields.get('sub_issues'):
            for sub_issue in self.fields.get('sub_issues'):
                if sub_issue.get('key'):
                    result.append(('SubTicket', {
                        'url': "https://st.yandex-team.ru/" + str(sub_issue['key']),
                        'text': str(sub_issue['key'])
                    }))
                if sub_issue.get('summary'):
                    result.append(('SubTicket summary', str(sub_issue['summary'])))
                if sub_issue.get('commits'):
                    for commit in sub_issue['commits']:
                        result.append(('SubTicket commit', {
                            'url': str(commit),
                            'text': str(commit)
                        }))
        if self.fields.get('release_name'):
            result.append(('Component', str(self.fields.get('release_name'))))
        if self.fields.get('release_version'):
            result.append(('Version', str(self.fields.get('release_version'))))
        if self.fields.get('release_deploy_group'):
            result.append(('Conductor Deploy Group', str(self.fields.get('release_deploy_group'))))
        if self.fields.get('release_ticket'):
            result.append(('Conductor Ticket', {
                'url': "https://c.yandex-team.ru/tickets/" + str(self.fields['release_ticket']),
                'text': str(self.fields['release_ticket'])
            }))
        result += super().full_info(set(['key', 'summary', 'sub_issues', 'release_name', 'release_version',
                                        'release_deploy_group', 'release_ticket']))
        return result

    @staticmethod
    def feed_color():
        return '#ff9f9f'

    @staticmethod
    def template_name():
        return 'release.html'

    def get_childs(self):
        if self.fields.get('sub_issues_uuids'):
            return Object.query.filter_by(project_id=self.project_id).\
                filter(Object.uuid.in_(self.fields.get('sub_issues_uuids'))).\
                order_by(Object.checked.asc(),Object.created_at.desc()).all()
        return []