from app import db


class Scheduler(db.Model):
    __tablename__ = "schedulers"

    id = db.Column(db.Integer, primary_key=True)
    scheduler_id = db.Column(db.Integer)
    description = db.Column(db.String())
    project_id = db.Column(db.Integer, db.ForeignKey('projects.id'))
    project = db.relationship("Project", back_populates="schedulers")

    def __init__(self, project_id, scheduler_id, description):
        self.project_id = project_id
        self.scheduler_id = scheduler_id
        self.description = description
