from app import db
from app.database.object import Object


class Service(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'service'
    }

    def __repr__(self):
        if "name" in self.fields:
            return str(self.fields['name']['en'])
        else:
            return str(self.value)

    def href_link(self):
        return "https://abc.yandex-team.ru/services/"+str(self.value)

    def full_info(self):
        result = [('ID', self.value)]
        if "name" in self.fields:
            if "en" in self.fields["name"]: result.append(('Name (En)', self.fields["name"]["en"]))
            if "ru" in self.fields["name"]: result.append(('Name (Ru)', self.fields["name"]["ru"]))
        return result