from app import db
from app.database.object import Object


class StTicket(Object):

    __mapper_args__ = {
        'polymorphic_identity': 'st_ticket'
    }

    def __repr__(self):
        if "key" in self.fields:
            name = str(self.fields['key'])
            if "summary" in self.fields:
                name += " - " + str(self.fields['summary'])
            return name
        else:
            return str(self.value)

    def href_link(self):
        return "https://st.yandex-team.ru/"+str(self.value)

    def full_info(self):
        result = [('Key', self.value)]
        return result

    @staticmethod
    def template_name():
        return 'st_ticket.html'