from flask import jsonify, request
import json
from app.idm import idm
from app.database import db
from app.database.organization import Organization
from app.database.user import User
from app import yauth


@idm.route('/info', methods=['GET'])
@yauth.tvm_ticket_required(2001600, 2001602)
def info():
    default_roles = {
        "slug": "role",
        "name": {
            "en": "Role",
            "ru": "Роль",
        },
        "values": {
            "read": {
                "set": "read",
                "name": {
                    "en": "Read only",
                    "ru": "Только чтение",
                },
            },
            "security": {
                "set": "security",
                "name": {
                    "en": "Security Engineer",
                    "ru": "Инженер ИБ",
                }
            },
            "admin": {
                "set": "admin",
                "name": {
                    "en": "Administration",
                    "ru": "Администрирование"
                }
            }
        }
    }

    info = {
        "code": 0,
        "roles": {
            "slug": "organization",
            "name": {
                "en": "Organization",
                "ru": "Организация",
            },
            "values": {
                "*": {
                    "name": {
                        "ru": "*",
                        "en": "*"
                    },
                    "roles": {
                        "slug": "project",
                        "name": {
                            "en": "Project",
                            "ru": "Проект"
                        },
                        "values": {
                            "*": {
                                "name": {
                                    "ru": "*",
                                    "en": "*"
                                },
                                "roles": default_roles
                            }
                        }
                    }
                }
            }
        }
    }

    organizations = Organization.query.order_by(Organization.name).all()
    for organization in organizations:
        organization_info = {
            "name": {
                "ru": organization.name,
                "en": organization.slug
            },
            "roles": {
                "slug": "project",
                "name": {
                    "en": "Project",
                    "ru": "Проект"
                },
                "values": {
                    "*": {
                        "name": {
                            "ru": "*",
                            "en": "*"
                        },
                        "roles": default_roles
                    }
                }
            }
        }
        for project in organization.projects:
            organization_info["roles"]["values"][project.slug] = {
                "name": {
                    "ru": project.name,
                    "en": project.slug
                },
                "roles": default_roles
            }
        info["roles"]["values"][organization.slug] = organization_info
    return jsonify(info)


@idm.route('/add-role', methods=['POST'])
@yauth.tvm_ticket_required(2001600, 2001602)
def add_role():
    login = request.form["login"]
    role = json.loads(request.form["role"])
    if 'project' in role:
        user = User.query.filter_by(login=login).filter_by(organization_slug=role["organization"]). \
            filter_by(project_slug=role["project"]).filter_by(role=role["role"]).first()
    else:
        role["project"] = "*"
        user = User.query.filter_by(login=login).filter_by(organization_slug=role["organization"]). \
            filter_by(role=role["role"]).first()
    if user:
        return jsonify({"code": 1, "warning": "User already has this role"})
    else:
        user = User(login=login, organization_slug=role["organization"], project_slug=role["project"],
                    role=role["role"])
        db.session.add(user)
        db.session.commit()
        return jsonify({"code": 0})


@idm.route('/remove-role', methods=['POST'])
@yauth.tvm_ticket_required(2001600, 2001602)
def remove_role():
    login = request.form["login"]
    role = json.loads(request.form["role"])
    user = User.query.filter_by(login=login).filter_by(organization_slug=role["organization"]). \
        filter_by(project_slug=role["project"]).filter_by(role=role["role"]).first()
    if user:
        db.session.delete(user)
        db.session.commit()
        return jsonify({"code": 0})
    else:
        return jsonify({"code": 1, "warning": "No role for this User"})


@idm.route('/get-all-roles', methods=['GET'])
@yauth.tvm_ticket_required(2001600, 2001602)
def get_all_roles():
    users = db.session.query(User).all()
    users_dict = {}
    for user in users:
        if user.login not in users_dict:
            users_dict[user.login] = []
        users_dict[user.login].append({'organization': user.organization_slug,
                                       'project': user.project_slug,
                                       'role': user.role})

    all_roles = {
        "code": 0,
        "users": []
    }
    for login in users_dict.keys():
        all_roles["users"].append({
            "login": login,
            "roles": users_dict[login]
        })
    return jsonify(all_roles)