import json
import requests
import os


class SandboxApi(object):
    oauth_token = os.getenv('OAUTH_TOKEN', '')
    url = "https://sandbox.yandex-team.ru/api/v1.0/"

    def _get_query(self, path):
        headers = {
            'Authorization': 'OAuth ' + self.oauth_token
        }
        try:
            r = requests.get(url=self.url + path, headers=headers)
        except Exception as e:
            return None
        return r.text

    def _post_query(self, path, json_data):
        headers = {
            'Authorization': 'OAuth ' + self.oauth_token
        }
        try:
            r = requests.post(url=self.url + path, headers=headers, json=json_data)
        except Exception as e:
            return None
        return r.text

    def _put_query(self, path, json_data):
        headers = {
            'Authorization': 'OAuth ' + self.oauth_token
        }

        try:
            r = requests.put(url=self.url + path, headers=headers, json=json_data)
        except Exception as e:
            return None

        return r.text

    def create_scheduler(self, project_id, description, pipeline_str, input_params_str, optional_params_str):
        schedule_template = {
            "data": {
                "author": "aleksei-m", # Change USERNAME
                "owner": "aleksei-m", # Change USERNAME
                "schedule": {
                    "fail_on_error": False,
                    "repetition": {
                        "interval": 7200,
                        "weekly": None
                    },
                    "retry": {
                        "ignore": True,
                        "interval": None
                    },
                    "sequential_run": False,
                    "start_time": None
                },
                "task": {
                    "custom_fields": [ # ADDING CUSTOM FIELDS
                        {
                            "name": "project_id",
                            "value": project_id
                        },
                        {
                            "name": "input_data",
                            "value": json.loads(input_params_str)
                        },
                        {
                            "name": "pipeline",
                            "value": json.loads(pipeline_str)
                        },
                        {
                            "name": "optional",
                            "value": json.loads(optional_params_str)
                        },
                    ],
                    "description": description,
                    "fail_on_any_error": False,
                    "hidden": False,
                    "important": True,
                    "kill_timeout": 0,
                    "max_restarts": 0,
                    "notifications": [
                        {
                            "recipients": [
                                "aleksei-m"
                            ],
                            "statuses": [
                                "EXCEPTION", "FAILURE"
                            ],
                            "transport": "email"
                        }
                    ],
                    "owner": "aleksei-m", # Change USERNAME
                    "priority": {
                        "class": "USER",
                        "subclass": "LOW"
                    },
                    "requirements": {
                    },
                }
            },
            "source": 0,
            "task_type": "SEC_DIS_META"
        }
        resp = self._post_query('scheduler', schedule_template)
        resp = json.loads(resp)
        schedule_id = resp['id']
        self._put_query('batch/schedulers/start', [schedule_id])
        return schedule_id
