from app.sandbox_api.collectors.abc_collector import AbcCollector
from app.sandbox_api.collectors.abc_resource import AbcResourceCollector
from app.sandbox_api.collectors.commit_collector import CommitCollector
from app.sandbox_api.collectors.conductor_release import ConductorRelease
from app.sandbox_api.collectors.handle_collector import HandleCollector
from app.sandbox_api.collectors.queue_collector import QueueCollector
from app.sandbox_api.collectors.repo_collector import RepoCollector
from app.sandbox_api.collectors.taxirel_releases import TaxiRelRelease
from app.sandbox_api.collectors.tsum_collector import TsumCollector
from app.sandbox_api.collectors.yt_collector import YtCollector
from app.sandbox_api.collectors.st_ticket_release_collector import StTicketRelCollector
from app.sandbox_api.collectors.st_ticket_collector import StTicketCollector
from app.sandbox_api.collectors.macros_collector import MacrosCollector
from app.sandbox_api.collectors.mailrel_releases import MailRelRelease


class SandboxDiscovery(object):
    @staticmethod
    def get_collectors_list():
        return {
            'ABC_COLLECTOR': AbcCollector(),
            'ABC_RESOURCE_COLLECTOR': AbcResourceCollector(),
            'COMMIT_COLLECTOR': CommitCollector(),
            'CONDUCTOR_RELEASE_COLLECTOR': ConductorRelease(),
            'HANDLE_COLLECTOR': HandleCollector(),
            'QUEUE_COLLECTOR': QueueCollector,
            'REPO_COLLECTOR': RepoCollector(),
            'TAXIREL_COLLECTOR': TaxiRelRelease(),
            'TSUM_COLLECTOR': TsumCollector(),
            'YT_COLLECTOR': YtCollector(),
            'ST_TICKET_REL_COLLECTOR': StTicketRelCollector(),
            'ST_TICKET_COLLECTOR': StTicketCollector(),
            'MACROS_COLLECTOR': MacrosCollector(),
            'MAIL_REL_COLLECTOR': MailRelRelease(),
        }
    @staticmethod
    def get_collector_params():
        all_params = {}
        for collector in SandboxDiscovery().get_collectors_list().values():
            all_params[collector.sandbox_name()] = {
                'optional_params': collector.optional_params_template()
            }
        return all_params