from flask_wtf import FlaskForm
from wtforms import StringField, TextAreaField, SubmitField, HiddenField, BooleanField, ValidationError
from wtforms.validators import DataRequired
import re

class OrganizationForm(FlaskForm):
    name = StringField('name', validators=[DataRequired()])
    slug = StringField('slug', validators=[DataRequired()])
    apikey = StringField('apikey')


def validate_st_issue(form, field):
    if form.enable_notifications.data:
        if not field.data:
            raise ValidationError("ST issue is required")
        if re.match(r"^[A-Z]+-[0-9]+$", field.data) is None:
            raise ValidationError("Invalid issue format")


class ProjectForm(FlaskForm):
    name = StringField('name', validators=[DataRequired()])
    enable_notifications = BooleanField('Enable Notifications', validators=[])
    st_issue = StringField('ST Issue for comments', validators=[validate_st_issue])
    slug = StringField('slug', validators=[DataRequired()])


class SanboxTaskForm(FlaskForm):
    description = TextAreaField('description', validators=[DataRequired()])
    pipeline = HiddenField('pipeline', validators=[DataRequired()])
    input_params = TextAreaField('input_params')
    optional_params = TextAreaField('optional_params')
    submit = SubmitField("Add")