import os
from app import create_app, db
from flask import request
from werkzeug.urls import url_encode

flask_app = create_app()
# Create all tables automatically
with flask_app.app_context():
    from app.database.user import User
    from app.database.organization import Organization
    from app.database.project import Project
    from app.database.scheduler import Scheduler
    from app.database.object import Object
    from app.database.repository import Repository
    from app.database.person import Person
    from app.database.commit import Commit
    from app.database.queue import Queue
    from app.database.service import Service
    from app.database.release import Release
    from app.database.handle import Handle
    from app.database.resource import Resource
    from app.database.st_ticket import StTicket
    from app.database.microservice import Microservice
    db.create_all()
    db.session.commit()


@flask_app.template_global()
def modify_query(**new_values):
    args = request.args.copy()

    for key, value in new_values.items():
        args[key] = value

    return '{}?{}'.format(request.path, url_encode(args))


if __name__ == '__main__':
    env = os.environ.get('FLASK_CONFIG', 'production')
    if env == 'production':
        flask_app.run(host="::", port=80)
    elif env == 'development':
        flask_app.run()