package com.yandex.burp.extensions;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpListener;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;

public class MollyStatsListener implements IHttpListener {
    private IExtensionHelpers helpers;
    private StatsCounter statsCounter;

    public MollyStatsListener(IBurpExtenderCallbacks callbacks, StatsCounter statsCounter) {
        this.helpers = callbacks.getHelpers();
        this.statsCounter = statsCounter;
    }

    @Override
    public void processHttpMessage(int toolFlag, boolean messageIsRequest, IHttpRequestResponse messageInfo) {
        // handle only request with response
        if (messageIsRequest) {
            return;
        }

        IResponseInfo response = helpers.analyzeResponse(messageInfo.getResponse());
        IRequestInfo request = helpers.analyzeRequest(messageInfo.getRequest());

        int statusCode = response.getStatusCode();
        String requestMethod = request.getMethod();

        statsCounter.save(requestMethod, statusCode);
    }
}
