package com.yandex.burp.extensions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import com.yandex.burp.extensions.config.BurpMollyScannerConfig;

/* TODO: this is really ugly */
public class ScanLogger {
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private List<String> validTypes = Arrays.asList("text/html", "text/css", "text/javascript",
            "application/x-javascript", "application/javascript", "text/plain");
    private BufferedWriter logWriter = null;

    public ScanLogger(IBurpExtenderCallbacks callbacks, BurpMollyScannerConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();

        String fileName = extConfig.getScanLogPath();
        if (extConfig.getScanLogTypes() != null) {
            this.validTypes = extConfig.getScanLogTypes();
        }

        File out = new File(fileName);
        try {
            FileWriter logFile = new FileWriter(out, true);
            logWriter = new BufferedWriter(logFile);
        } catch (IOException ex) {
            try {
                OutputStream stderr = callbacks.getStderr();
                stderr.write(helpers.stringToBytes("File " + fileName + "open error, no log will be written!\n"));
            } catch (IOException exc) {
                /**/
            }
        }
    }

    public void logItem(IHttpRequestResponse messageInfo, int toolFlag) {
        if (logWriter == null) return;

        IRequestInfo requestInfo = helpers.analyzeRequest(messageInfo.getHttpService(), messageInfo.getRequest());
        IResponseInfo respInfo = helpers.analyzeResponse(messageInfo.getResponse());

        /* XXX: log everything */
        /*
        boolean needLog = false;
        for (String header : respInfo.getHeaders()) {
            String[] chunks = header.split(":", 2);

            if (chunks.length != 2 || !chunks[0].toUpperCase().equals("CONTENT-TYPE"))
                continue;

            if (validTypes.contains(chunks[1].trim().split(";", 2)[0].trim().toLowerCase())) {
                needLog = true;
                break;
            }
        }

        if (!needLog) return;
        */

        try {
            StringWriter logEntry = new StringWriter();
            logEntry.append(requestInfo.getMethod());
            logEntry.append(";\"");
            logEntry.append(requestInfo.getUrl().toString().replace("\"", "\\"));
            logEntry.append("\";");
            logEntry.append(Integer.toString(respInfo.getStatusCode()));
            logEntry.append("\";");
            logEntry.append(Integer.toString(toolFlag));
            logEntry.append("\n");
            logWriter.write(logEntry.toString());
        } catch (IOException ex) {
            /**/
        }
    }

    public void finish() {
        try {
            logWriter.close();
        } catch (IOException ex) {
            /**/
        }
    }
}
