package com.yandex.burp.extensions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IScanIssue;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

public class StatsCounter {

    // Method -> Response code -> Count
    private Map<String, Map<Integer, Integer>> stats = new HashMap<>();

    synchronized void save(String method, Integer responseCode) {
        Map<Integer, Integer> responseCodeToCount = stats.get(method);

        if (stats.get(method) == null) {
            responseCodeToCount = new HashMap<Integer, Integer>();
            stats.put(method, responseCodeToCount);
        }

        responseCodeToCount.merge(responseCode, 1, Integer::sum);
    }

    public synchronized IScanIssue generateIssue() {
        List<StatsMethod> methods = new ArrayList<>();

        for (Map.Entry<String, Map<Integer, Integer>> methodEntry : stats.entrySet()) {
            List<StatResponse> statResponses = new ArrayList<>();
            for (Map.Entry<Integer, Integer> responseEntry : methodEntry.getValue().entrySet()) {
                statResponses.add(new StatResponse(responseEntry.getKey(), responseEntry.getValue()));
            }
            methods.add(new StatsMethod(methodEntry.getKey(), statResponses));
        }

        Gson gson = new Gson();
        String json = gson.toJson(methods);

        return new StatsIssue(json);
    }
}

class StatsIssue implements IScanIssue {

    private String detail;

    StatsIssue(String detail) {
        this.detail = detail;
    }

    @Override
    public URL getUrl() {
        URL url = null;
        try {
            url = new URL("http", "localhost", 8080, "file");
        } catch (MalformedURLException ex) {
            // nothing
        }
        return url;
    }

    @Override
    public String getIssueName() {
        return "Stats Issue";
    }

    @Override
    public int getIssueType() {
        return 0;
    }

    @Override
    public String getSeverity() {
        return "Information";
    }

    @Override
    public String getConfidence() {
        return "Certain";
    }

    @Override
    public String getIssueBackground() {
        return "";
    }

    @Override
    public String getRemediationBackground() {
        return "";
    }

    @Override
    public String getIssueDetail() {
        return detail;
    }

    @Override
    public String getRemediationDetail() {
        return "";
    }

    @Override
    public IHttpRequestResponse[] getHttpMessages() {
        return null;
    }

    @Override
    public IHttpService getHttpService() {
        return new StubHttpService();
    }
}

class StubHttpService implements IHttpService {

    @Override
    public String getHost() {
        return "localhost";
    }

    @Override
    public int getPort() {
        return 8080;
    }

    @Override
    public String getProtocol() {
        return "http";
    }
}


class StatsMethod {

    StatsMethod(String method, List<StatResponse> responses) {
        this.method = method;
        this.responses = responses;
    }

    @SerializedName("method")
    private String method;

    @SerializedName("responses")
    private List<StatResponse> responses;
}

class StatResponse {

    StatResponse(Integer statusCode, Integer count) {
        this.statusCode = statusCode;
        this.count = count;
    }

    @SerializedName("status_code")
    private Integer statusCode;

    @SerializedName("count")
    private Integer count;
}
