package com.yandex.burp.extensions.modifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import com.yandex.burp.extensions.config.BurpMollyScannerConfig;


public class YaIpSpoofer implements IMollyModifier {
    private final IBurpExtenderCallbacks callbacks;
    private final IExtensionHelpers helpers;
    private BurpMollyScannerConfig extConfig;
    private static final List<String> HEADER_NAMES = Arrays.asList("X-Real-IP", "X-Forwarded-For", "X-Forwarded-For-Y");

    public YaIpSpoofer(IBurpExtenderCallbacks callbacks, BurpMollyScannerConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
        this.extConfig = extConfig;
    }

    @Override
    public void processHttpMessage(int toolFlag, boolean messageIsRequest, IHttpRequestResponse messageInfo) {
        if (!messageIsRequest) {
            return;
        }

        if (extConfig.getSpoofedIp() == null) {
            return;
        }

        IRequestInfo requestInfo = helpers.analyzeRequest(messageInfo.getRequest());
        List<String> reqHeaders = requestInfo.getHeaders();

        /*
            first check if there are existing headers,
            so we won't break any additional checks
        */
        for (String existing : reqHeaders) {
            for (String marker : HEADER_NAMES) {
                if (existing.toUpperCase().startsWith(marker.toUpperCase())) {
                    return;
                }
            }
        }
        List<String> newHeaders = new ArrayList<String>();
        for (String h : reqHeaders) {
            newHeaders.add(h);
        }
        for (String inj : HEADER_NAMES) {
            newHeaders.add(inj + ": " + extConfig.getSpoofedIp());
        }

        byte[] body;
        byte[] modifiedReq;
        if (helpers.bytesToString(messageInfo.getRequest()).length() > requestInfo.getBodyOffset()) {
            body = helpers.stringToBytes(helpers.bytesToString(messageInfo.getRequest()).substring(requestInfo.getBodyOffset()));
            modifiedReq = helpers.buildHttpMessage(newHeaders, body);
        } else {
            modifiedReq = helpers.buildHttpMessage(newHeaders, "".getBytes());
        }
        messageInfo.setRequest(modifiedReq);
    }
}
