package collaborator

import (
	"encoding/json"
	"fmt"
	"log"
	"sort"
	"sync"

	"a.yandex-team.ru/security/libs/go/yahttp"
)

func fetch(upstream string, query string, out chan<- *Response, wg *sync.WaitGroup) {
	wg.Add(1)
	go func() {
		defer wg.Done()
		r, err := yahttp.Get(fmt.Sprintf("http://%s/burpresults?%s", upstream, query))
		if err != nil {
			log.Println("failed to get upstream response: ", err.Error())
			return
		}
		defer yahttp.GracefulClose(r.Body)

		var response Response
		err = json.NewDecoder(r.Body).Decode(&response)
		if err != nil {
			log.Println("failed to parse upstream response: ", err.Error())
			return
		}
		out <- &response
	}()
}

func FetchAll(upstreams []string, query string) Response {
	out := make(chan *Response, len(upstreams))
	var wg sync.WaitGroup

	for _, upstream := range upstreams {
		fetch(upstream, query, out, &wg)
	}
	wg.Wait()
	close(out)

	res := Response{}
	for r := range out {
		if len(r.Requests) > 0 {
			res.Requests = append(res.Requests, r.Requests...)
		}
	}

	sort.Sort(res.Requests)
	return res
}
