package collaborator

type (
	Request []struct {
		Protocol          string      `json:"protocol"`
		OpCode            string      `json:"opCode"`
		InteractionString string      `json:"interactionString"`
		ClientPart        string      `json:"clientPart"`
		Data              interface{} `json:"data"`
		Time              string      `json:"time"`
		Client            string      `json:"client"`
	}

	Response struct {
		Requests Request `json:"responses,omitempty"`
	}
)

func (slice Request) Len() int {
	return len(slice)
}

func (slice Request) Less(i, j int) bool {
	return slice[i].Time < slice[j].Time
}

func (slice Request) Swap(i, j int) {
	slice[i], slice[j] = slice[j], slice[i]
}
