package com.yandex.burp.extensions.plugins;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import burp.IRequestInfo;
import burp.IResponseInfo;


/**
 * Created by a-abakumov on 24/03/2017.
 */
public class Utils {

    private static final Pattern YA_CSRF = Pattern.compile("^[a-f0-9]{40}:\\d+$");

    public static String getContentType(IResponseInfo resp) {
        String contentTypeValue = getHeaderValue(resp, "Content-Type");
        if (contentTypeValue != null) {
            return contentTypeValue.split(";", 2)[0].trim().toLowerCase();
        } else {
            return null;
        }
    }

    public static String getHeaderValue(IResponseInfo resp, String headerName) {
        for (String header : resp.getHeaders()) {
            String[] chunks = header.split(":", 2);

            if (chunks.length != 2 || !chunks[0].toLowerCase().equals(headerName.toLowerCase()))
                continue;

            return chunks[1].trim();
        }
        return null;
    }

    public static String getHeaderValue(IRequestInfo req, String headerName) {
        for (String header : req.getHeaders()) {
            String[] chunks = header.split(":", 2);

            if (chunks.length != 2 || !chunks[0].toLowerCase().equals(headerName.toLowerCase()))
                continue;

            return chunks[1].trim();
        }
        return null;
    }

    public static String getHeaderValue(List<String> headers, String headerName) {
        for (String header : headers) {
            String[] chunks = header.split(":", 2);

            if (chunks.length != 2 || !chunks[0].toLowerCase().equals(headerName.toLowerCase()))
                continue;

            return chunks[1].trim();
        }
        return null;
    }

    public static List<String> setHeaderValue(List<String> headers, String headerName, String headerValue) {
        headers.removeIf(header -> header != null && header.toLowerCase().startsWith(headerName.toLowerCase() + ":"));
        headers.add(headerName + ": " + headerValue);
        return headers;
    }

    public static boolean isYandexCSRF(String input) {
        Matcher matcher = YA_CSRF.matcher(input);
        return matcher.matches();
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

}
