package com.yandex.burp.extensions.plugins.audit;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


/**
 * Created by shikari on 18/12/2018.
 */

public class BlackBoxProxyChecker implements IAuditPlugin {

    private static final List<String> HEADER_NAMES = Arrays.asList("X-Real-IP", "X-Forwarded-For", "X-Forwarded-For-Y");
    private static final List<String> HEADER_HOST = Arrays.asList("Host: dist.yandex.ru", "Host: blackbox.yandex.net");
    private static final List<String> TEST_PATH = Arrays.asList("/", "/blackbox", "/blackbox/");
    private static final String HEADER_VALUE = "213.180.205.35";
    private final int ISSUE_TYPE = 0x080a0011;
    private final String ISSUE_NAME = "BlackBox Proxy Checker";
    private final String SEVERITY = "Medium";
    private final String CONFIDENCE = "Certain";
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private HashSet<String> flags;


    public BlackBoxProxyChecker(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
        this.flags = new HashSet<>();
    }


    @Override
    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        IRequestInfo req = helpers.analyzeRequest(baseRequestResponse.getRequest());
        if (resp == null | req == null) return null;

        List<IScanIssue> issues = new ArrayList<>();
        String hostUrl = baseRequestResponse.getHttpService().toString();

        if (flags.contains(hostUrl)) return null;
        else flags.add(hostUrl);

        for (String host : HEADER_HOST) {
            List<String> headers = helpers.analyzeRequest(baseRequestResponse).getHeaders();
            // delete and add custom host headers
            headers.removeIf(header -> header != null && header.toLowerCase().startsWith("host:"));
            headers.add(host);

            for (String path : TEST_PATH) {
                for (String pheader : HEADER_NAMES) {
                    // delete and add permanent proxy headers
                    headers.removeIf(header -> header != null && header.toLowerCase().startsWith(pheader.toLowerCase()));
                    headers.add(pheader + ": " + HEADER_VALUE);
                }

                /* XXX: WTF? */
                String finalPayload =  "GET " + path + " HTTP/1.1";
                headers.set(0, finalPayload);

                URL url = helpers.analyzeRequest(baseRequestResponse).getUrl();
                byte[] attackReq = helpers.buildHttpMessage(headers, null);
                IHttpRequestResponse attackRequestResponse = callbacks.makeHttpRequest(baseRequestResponse.getHttpService(), attackReq);
                if (attackRequestResponse == null || attackRequestResponse.getResponse() == null) continue;
                String marker = helpers.bytesToString(attackRequestResponse.getResponse());

                //Request/response check
                if ((attackRequestResponse != null) && (helpers.bytesToString(attackRequestResponse.getRequest()).contains(host)
                    && (marker.contains("BlackBox error")) || marker.contains("Index of /"))) {

                        String issueDetails = "Incorrect Proxy detected on host: <b>" + hostUrl + "</b>.<br><br>" +
                                "Internal service is available from outside.<br><br>" +
                                "You may check your webserver configuration with https://wiki.yandex-team.ru/product-security/yodax/.<br><br>" +
                                "Additional information: https://wiki.yandex-team.ru/security/for/admins/." ;

                        issues.add(new CustomScanIssue(attackRequestResponse.getHttpService(), url,
                            new IHttpRequestResponse[]{callbacks.applyMarkers(attackRequestResponse, null, null)},
                                issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                                "", "", ""));

                }
            }
        }

        return issues.isEmpty() ? null : issues;
    }
}
