package com.yandex.burp.extensions.plugins.audit;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class PginxAdminPlugin implements IAuditPlugin {
    private static final List<String> TEST_PATH = Arrays.asList("/admin");
    private final int ISSUE_TYPE = 0x080a0012;
    private final String ISSUE_NAME = "Pginx Admin Module Enabled";
    private final String SEVERITY = "Medium";
    private final String CONFIDENCE = "Certain";
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private HashSet<String> flags;


    public PginxAdminPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
        this.flags = new HashSet<>();
    }


    @Override
    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        IRequestInfo req = helpers.analyzeRequest(baseRequestResponse.getRequest());
        if (resp == null | req == null) return null;

        List<IScanIssue> issues = new ArrayList<>();
        String hostUrl = baseRequestResponse.getHttpService().toString();

        if (flags.contains(hostUrl)) return null;
        else flags.add(hostUrl);

        List<String> headers = helpers.analyzeRequest(baseRequestResponse).getHeaders();
        for (String path : TEST_PATH) {
            String finalPayload =  "GET " + path + " HTTP/1.1";
            headers.set(0, finalPayload);

            URL url = helpers.analyzeRequest(baseRequestResponse).getUrl();
            byte[] attackReq = helpers.buildHttpMessage(headers, null);
            IHttpRequestResponse attackRequestResponse = callbacks.makeHttpRequest(baseRequestResponse.getHttpService(), attackReq);
            if (attackRequestResponse == null || attackRequestResponse.getResponse() == null) continue;
            String responseBody = helpers.bytesToString(attackRequestResponse.getResponse());

            //Request/response check
            if (attackRequestResponse != null && responseBody.contains("shutdown - shut down balancer")) {
                String issueDetails = "Balancer Admin Module detected on host: <b>" + hostUrl + "</b>.<br>" +
                    "Internal methods are available from outside.<br><br>";


                issues.add(new CustomScanIssue(attackRequestResponse.getHttpService(), url,
                    new IHttpRequestResponse[]{callbacks.applyMarkers(attackRequestResponse, null, null)},
                    issueDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", ""));
            }
        }

        return issues.isEmpty() ? null : issues;
    }
}
