package com.yandex.burp.extensions.plugins.audit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IRequestInfo;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


public class Spring4ShellPlugin implements IAuditPlugin {

    private static final int ISSUE_TYPE = 0x080a0068;
    private static final String ISSUE_NAME = "Spring Remote Code Execution";
    private static final String SEVERITY = "High";
    private static final String CONFIDENCE = "Certain";

    private static final String PAYLOAD = "class.module.layer.molly";

    private final IBurpExtenderCallbacks callbacks;
    private final IExtensionHelpers helpers;
    private final Set<String> checkedPaths = new HashSet<>();

    public Spring4ShellPlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        if ((insertionPoint.getInsertionPointType() != IScannerInsertionPoint.INS_PARAM_NAME_URL))
            return null;

        List<IScanIssue> issues = new ArrayList<>();
        IHttpService httpService = baseRequestResponse.getHttpService();
        IRequestInfo request = this.helpers.analyzeRequest(httpService, baseRequestResponse.getRequest());

        if (request.getUrl() == null)
            return null;

        if (checkedPaths.contains(request.getUrl().getPath()))
            return null;

        IHttpRequestResponse attackRequest = this.callbacks.makeHttpRequest(httpService,
        insertionPoint.buildRequest(PAYLOAD.getBytes()));
        if (attackRequest.getResponse() == null)
            return null;
        IResponseInfo attackResponse = helpers.analyzeResponse(attackRequest.getResponse());
        if (attackResponse.getStatusCode() != 500)
            return null;

        IHttpRequestResponse healthRequest = this.callbacks.makeHttpRequest(httpService,
            insertionPoint.buildRequest(new byte[0]));
        if (healthRequest.getResponse() == null)
            return null;
        IResponseInfo healthResponse = helpers.analyzeResponse(healthRequest.getResponse());

        if (healthResponse.getStatusCode() != 500) {
            List<int[]> requestMarkers = new ArrayList<>(1);
            requestMarkers.add(insertionPoint.getPayloadOffsets(PAYLOAD.getBytes()));

            String attackDetails = "Server returned 500 on request to " +
                    this.helpers.analyzeRequest(httpService, attackRequest.getRequest()).getUrl() +
                    ". Maybe it is vulnerable to Spring4Shell vulnerability. Please update Spring version.";

            issues.add(new CustomScanIssue(
                    attackRequest.getHttpService(),
                    request.getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(attackRequest, requestMarkers, null)},
                    attackDetails,
                    ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", "")
            );
        }

        checkedPaths.add(request.getUrl().getPath());
        return issues.isEmpty() ? null : issues;
    }
}


