package com.yandex.burp.extensions.plugins.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.Utils;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


/**
 * Created by a-abakumov on 14/02/2017.
 */
public class StringReplacePlugin implements IAuditPlugin {

    private static final String Payload = "$$";
    private final int ISSUE_TYPE = 0x080a0001;
    private final String ISSUE_NAME = "String Replace Issue";
    private final String SEVERITY = "Information";
    private final String CONFIDENCE = "Tentative";
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    public StringReplacePlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null || resp.getStatusCode() != 200) return null;

        List<IScanIssue> issues = new ArrayList<>();
        IHttpService httpService = baseRequestResponse.getHttpService();

        String contentTypeHeader = Utils.getContentType(resp);
        if (contentTypeHeader != null && !contentTypeHeader.toUpperCase().contains("TEXT/HTML")) return null;

        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String finalPayload = uuid.substring(0, 5) + Payload + uuid.substring(0, 5);
        String signature = uuid.substring(0, 5) + "$" + uuid.substring(0, 5);

        IHttpRequestResponse attack = this.callbacks.makeHttpRequest(httpService,
                insertionPoint.buildRequest(this.helpers.stringToBytes(finalPayload)));
        if (attack.getResponse() == null) return null;
        String body = helpers.bytesToString(attack.getResponse());

        if (body.contains(signature)) {
            List requestMarkers = new ArrayList(1);
            List responseMarkers = new ArrayList(1);
            requestMarkers.add(insertionPoint.getPayloadOffsets(this.helpers.stringToBytes(finalPayload)));
            responseMarkers.add(new int[]{body.indexOf(signature), body.indexOf(signature) + signature.length()});

            String attackDetails = "Maybe String.prototype.replace() issue. Need manual checking";

            issues.add(new CustomScanIssue(attack.getHttpService(),
                    this.helpers.analyzeRequest(attack).getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(attack, requestMarkers, responseMarkers)},
                    attackDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", ""));
        }
        if (issues.size() > 0) return issues;
        return null;
    }
}
