package com.yandex.burp.extensions.plugins.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IResponseInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import com.yandex.burp.extensions.plugins.CustomScanIssue;
import com.yandex.burp.extensions.plugins.config.BurpMollyPackConfig;


/**
 * Created by ezaitov on 14/12/2017.
 */
public class YandexLoginCookiePlugin implements IAuditPlugin {

    private final int ISSUE_TYPE = 0x080a0002;
    private final String ISSUE_NAME = "YandexLogin cookie Issue";
    private final String SEVERITY = "Information";
    private final String CONFIDENCE = "Tentative";
    private IBurpExtenderCallbacks callbacks;
    private IExtensionHelpers helpers;

    public YandexLoginCookiePlugin(IBurpExtenderCallbacks callbacks, BurpMollyPackConfig extConfig) {
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
    }

    public List<IScanIssue> doScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        if (insertionPoint.getInsertionPointType() != IScannerInsertionPoint.INS_PARAM_COOKIE) return null;

        IResponseInfo resp = helpers.analyzeResponse(baseRequestResponse.getResponse());
        if (resp == null || resp.getStatusCode() != 200) return null;

        List<IScanIssue> issues = new ArrayList<>();
        IHttpService httpService = baseRequestResponse.getHttpService();

        String signature = UUID.randomUUID().toString().replaceAll("-", "");
        String payload = "yandex_login=" + signature;

        IHttpRequestResponse attack = this.callbacks.makeHttpRequest(httpService,
                insertionPoint.buildRequest(this.helpers.stringToBytes(payload)));
        if (attack.getResponse() == null) return null;
        String body = helpers.bytesToString(attack.getResponse());

        if (body.contains(signature)) {
            List requestMarkers = new ArrayList(1);
            List responseMarkers = new ArrayList(1);
            requestMarkers.add(insertionPoint.getPayloadOffsets(this.helpers.stringToBytes(signature)));
            responseMarkers.add(new int[]{body.indexOf(signature), body.indexOf(signature) + signature.length()});

            String attackDetails = "Maybe yandex_login cookie. Need manual checking";

            issues.add(new CustomScanIssue(attack.getHttpService(),
                    this.helpers.analyzeRequest(attack).getUrl(),
                    new IHttpRequestResponse[]{this.callbacks.applyMarkers(attack, requestMarkers, responseMarkers)},
                    attackDetails, ISSUE_TYPE, ISSUE_NAME, SEVERITY, CONFIDENCE,
                    "", "", ""));
        }
        if (issues.size() > 0) return issues;
        return null;
    }
}
